/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.TimeZone;

public class Bug15074Test
extends AbstractAJAXSession {
    private Appointment appointment;

    public Bug15074Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 15074 Test");
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setStartDate(TimeTools.D("07.12.2007 00:00", TimeZone.getTimeZone("UTC")));
        this.appointment.setEndDate(TimeTools.D("08.12.2007 00:00", TimeZone.getTimeZone("UTC")));
        this.appointment.setFullTime(true);
        this.appointment.setRecurrenceType(4);
        this.appointment.setInterval(1);
        this.appointment.setDayInMonth(7);
        this.appointment.setMonth(11);
        this.appointment.setIgnoreConflicts(true);
        InsertRequest appointmentInsertRequest = new InsertRequest(this.appointment, this.getClient().getValues().getTimeZone());
        AppointmentInsertResponse appointmentInsertResponse = this.getClient().execute(appointmentInsertRequest);
        appointmentInsertResponse.fillAppointment(this.appointment);
    }

    @Override
    protected void tearDown() throws Exception {
        DeleteRequest appointmentDeleteRequest = new DeleteRequest(this.appointment);
        this.getClient().execute(appointmentDeleteRequest);
        super.tearDown();
    }

    public void testBug() throws Exception {
        int[] columns = new int[]{1};
        AllRequest allRequest = new AllRequest(this.client.getValues().getPrivateAppointmentFolder(), columns, TimeTools.D("01.12.2009 00:00", TimeZone.getTimeZone("UTC")), TimeTools.D("01.01.2010 00:00", TimeZone.getTimeZone("UTC")), TimeZone.getTimeZone("UTC"), false);
        CommonAllResponse allResponse = this.client.execute(allRequest);
        Object[][] objects = allResponse.getArray();
        boolean found = false;
        for (Object[] object : objects) {
            if (((Integer)object[0]).intValue() != this.appointment.getObjectID()) continue;
            found = true;
            break;
        }
        Bug15074Test.assertTrue((String)"Unable to find appointment in this month.", (boolean)found);
    }
}

