/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.ListRequest;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDInt;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Bug14357Test
extends AbstractAJAXSession {
    private Appointment appointment;

    public Bug14357Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.appointment = new Appointment();
        this.appointment.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.appointment.setTitle("Bug14357Test");
        this.appointment.setStartDate(TimeTools.D("01.01.2010 13:00", this.getClient().getValues().getTimeZone()));
        this.appointment.setEndDate(TimeTools.D("01.01.2010 14:00", this.getClient().getValues().getTimeZone()));
        this.appointment.setRecurrenceType(4);
        this.appointment.setDays(62);
        this.appointment.setDayInMonth(2);
        this.appointment.setMonth(1);
        this.appointment.setInterval(1);
        this.appointment.setIgnoreConflicts(true);
        InsertRequest appointmentInsertRequest = new InsertRequest(this.appointment, this.getClient().getValues().getTimeZone());
        AppointmentInsertResponse appointmentInsertResponse = this.getClient().execute(appointmentInsertRequest);
        appointmentInsertResponse.fillAppointment(this.appointment);
    }

    public void testBug14357() throws Exception {
        this.checkYear(1, 2010, 2);
        this.checkYear(2, 2011, 2);
        this.checkYear(3, 2012, 2);
        this.checkYear(4, 2013, 4);
        this.checkYear(5, 2014, 4);
        this.checkYear(6, 2015, 3);
        this.checkYear(7, 2016, 2);
        this.checkYear(8, 2017, 2);
        this.checkYear(9, 2018, 2);
        this.checkYear(10, 2019, 4);
    }

    @Override
    public void tearDown() throws Exception {
        DeleteRequest appointmentDeleteRequest = new DeleteRequest(this.appointment);
        this.getClient().execute(appointmentDeleteRequest);
        super.tearDown();
    }

    private void checkYear(int position, int year, int expectedDay) throws Exception {
        Date expectedStartOfappointment = TimeTools.D(expectedDay + ".02." + year + " 13:00");
        ListIDs list = new ListIDs();
        list.add(new ListIDInt(this.getClient().getValues().getPrivateAppointmentFolder(), this.getClient().getValues().getUserId()));
        MyListRequest listRequest = new MyListRequest(list, new int[]{1, 201}, true, this.getClient().getValues().getPrivateAppointmentFolder(), position, this.appointment.getObjectID(), this.getClient().getValues().getUserId());
        CommonListResponse listResponse = this.getClient().execute(listRequest);
        JSONArray foundAppointment = null;
        JSONArray json = (JSONArray)listResponse.getData();
        for (int i = 0; i < json.length(); ++i) {
            JSONArray appointmentJson = json.getJSONArray(i);
            if (appointmentJson.getInt(0) != this.appointment.getObjectID()) continue;
            foundAppointment = appointmentJson;
        }
        Bug14357Test.assertNotNull((String)"Did not find appointment.", foundAppointment);
        long startLong = foundAppointment.getLong(1);
        Bug14357Test.assertEquals((String)"Wrong start date of occurrence.", (long)expectedStartOfappointment.getTime(), (long)startLong);
    }

    private class MyListRequest
    extends ListRequest {
        private final int pos;
        private final int recId;
        private final int createdBy;
        private final int folder;

        public MyListRequest(ListIDs identifier, int[] columns, boolean failOnError, int folder, int pos, int recId, int createdBy) {
            super(identifier, columns, failOnError);
            this.folder = folder;
            this.pos = pos;
            this.recId = recId;
            this.createdBy = createdBy;
        }

        @Override
        public Object getBody() throws JSONException {
            JSONArray array = new JSONArray();
            JSONObject json = new JSONObject();
            json.put("folder", this.folder);
            json.put("id", this.recId);
            json.put("recurrence_position", this.pos);
            json.put("recurrence_id", this.recId);
            json.put("createdBy", this.createdBy);
            array.put((Object)json);
            return array;
        }
    }
}

