/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetChangeExceptionsRequest;
import com.openexchange.ajax.appointment.action.GetChangeExceptionsResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.cache.OXCachingExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import java.util.List;

public class GetChangeExceptionsTest
extends AbstractAJAXSession {
    private Appointment appointment;
    private Appointment exception1;
    private Appointment exception2;

    public GetChangeExceptionsTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.appointment = new Appointment();
        this.appointment.setStartDate(TimeTools.D("01.05.2013 08:00"));
        this.appointment.setEndDate(TimeTools.D("01.05.2013 09:00"));
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setAlarm(30);
        this.appointment.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setTitle("Change Exception test");
        InsertRequest insertRequest = new InsertRequest(this.appointment, this.getClient().getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.getClient().execute(insertRequest);
        insertResponse.fillAppointment(this.appointment);
        this.exception1 = new Appointment();
        this.exception1.setObjectID(this.appointment.getObjectID());
        this.exception1.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.exception1.setRecurrenceType(0);
        this.exception1.setIgnoreConflicts(true);
        this.exception1.setLastModified(new Date(Long.MAX_VALUE));
        this.exception1.setRecurrencePosition(2);
        this.exception1.setAlarm(30);
        this.exception1.setTitle("Exception 1");
        UpdateRequest updateRequest = new UpdateRequest(this.exception1, this.getClient().getValues().getTimeZone());
        this.getClient().execute(updateRequest);
        this.exception2 = new Appointment();
        this.exception2.setObjectID(this.appointment.getObjectID());
        this.exception2.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.exception2.setRecurrenceType(0);
        this.exception2.setIgnoreConflicts(true);
        this.exception2.setLastModified(new Date(Long.MAX_VALUE));
        this.exception2.setRecurrencePosition(5);
        this.exception2.setAlarm(30);
        this.exception2.setTitle("Exception 2");
        updateRequest = new UpdateRequest(this.exception2, this.getClient().getValues().getTimeZone());
        this.getClient().execute(updateRequest);
    }

    public void testGetChangeExceptions() throws Exception {
        int[] columns = new int[]{1, 206, 200, 204};
        GetChangeExceptionsRequest request = new GetChangeExceptionsRequest(this.appointment.getParentFolderID(), this.appointment.getObjectID(), columns);
        GetChangeExceptionsResponse response = this.getClient().execute(request);
        List<Appointment> exceptions = response.getAppointments(this.getClient().getValues().getTimeZone());
        GetChangeExceptionsTest.assertEquals((String)"Wrong amount of returned exceptions.", (int)2, (int)exceptions.size());
        boolean foundFirst = false;
        boolean foundSecond = false;
        for (Appointment exception : exceptions) {
            GetChangeExceptionsTest.assertEquals((String)"Wrong recurrence id.", (int)this.appointment.getObjectID(), (int)exception.getRecurrenceID());
            if (exception.getTitle().equals(this.exception1.getTitle())) {
                foundFirst = true;
            }
            if (!exception.getTitle().equals(this.exception2.getTitle())) continue;
            foundSecond = true;
        }
        GetChangeExceptionsTest.assertTrue((String)"Missing exception.", (boolean)foundFirst);
        GetChangeExceptionsTest.assertTrue((String)"Missing exception.", (boolean)foundSecond);
    }

    public void testPermission() throws Exception {
        int[] columns = new int[]{1, 206, 200};
        GetChangeExceptionsRequest request = new GetChangeExceptionsRequest(this.appointment.getParentFolderID(), this.appointment.getObjectID(), columns, false);
        GetChangeExceptionsResponse response = new AJAXClient(AJAXClient.User.User4).execute(request);
        GetChangeExceptionsTest.assertTrue((String)"Missing error.", (boolean)response.hasError());
        OXException oxException = response.getException();
        GetChangeExceptionsTest.assertEquals((String)"Wrong error.", (Object)OXCachingExceptionCode.CATEGORY_PERMISSION_DENIED, (Object)oxException.getCategory());
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.appointment != null) {
            this.appointment.setLastModified(new Date(Long.MAX_VALUE));
            this.getClient().execute(new DeleteRequest(this.appointment));
        }
        super.tearDown();
    }
}

