/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.java.Autoboxing;
import java.util.Date;
import java.util.TimeZone;

public final class FunambolTest
extends AbstractAJAXSession {
    private AJAXClient client;
    private int folderId;
    private TimeZone timeZone;
    private Appointment appointment;

    public FunambolTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.folderId = this.client.getValues().getPrivateAppointmentFolder();
        this.timeZone = this.client.getValues().getTimeZone();
        this.appointment = new Appointment();
        this.appointment.setParentFolderID(this.folderId);
        this.appointment.setTitle("TestCreationTime");
        this.appointment.setStartDate(new Date(TimeTools.getHour(0, this.timeZone)));
        this.appointment.setEndDate(new Date(TimeTools.getHour(1, this.timeZone)));
        this.appointment.setIgnoreConflicts(true);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.appointment));
        super.tearDown();
    }

    public void testAppointmentCreationTime() throws Throwable {
        Date timeBeforeCreation = new Date(this.client.getValues().getServerTime().getTime() - 1L);
        CommonInsertResponse insertResponse = this.client.execute(new InsertRequest(this.appointment, this.timeZone));
        insertResponse.fillObject((DataObject)this.appointment);
        GetResponse response = this.client.execute(new GetRequest(this.appointment));
        Appointment reload = response.getAppointment(this.timeZone);
        Date lastModified = reload.getLastModified();
        Date timeAfterCreation = new Date(this.client.getValues().getServerTime().getTime() + 1L);
        FunambolTest.assertTrue((String)"Appointment creation time is not after time request before creation.", (boolean)lastModified.after(timeBeforeCreation));
        FunambolTest.assertTrue((String)"Appointment creation time is not before time request after creation.", (boolean)lastModified.before(timeAfterCreation));
        FunambolTest.assertEquals((String)"Last modified and creation date are different.", (Object)Autoboxing.L((long)(lastModified.getTime() / 1000L)), (Object)Autoboxing.L((long)(reload.getCreationDate().getTime() / 1000L)));
    }
}

