/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.ContactTest;
import com.openexchange.ajax.FolderTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.LinkObject;
import com.openexchange.tools.URLParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONWriter;

public class LinkTest
extends AbstractAJAXTest {
    private static final String LINK_URL = "/ajax/link";

    public LinkTest(String name) {
        super(name);
    }

    public static int[] insertLink(WebConversation webCon, String host, String session) throws Exception {
        FolderObject fo = FolderTest.getStandardContactFolder(webCon, host, session);
        int fid1 = fo.getObjectID();
        Contact co = new Contact();
        co.setSurName("Meier");
        co.setGivenName("Herbert");
        co.setDisplayName("Meier, Herbert");
        co.setParentFolderID(fid1);
        int oid1 = ContactTest.insertContact(webCon, co, "http://" + host, session);
        fo = FolderTest.getStandardCalendarFolder(webCon, host, session);
        int fid2 = fo.getObjectID();
        Appointment ao = new Appointment();
        ao.setTitle("Nasenmann");
        Calendar c = Calendar.getInstance();
        c.set(11, 8);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        long startTime = c.getTimeInMillis();
        long endTime = startTime + 3600000L;
        ao.setStartDate(new Date(startTime));
        ao.setEndDate(new Date(endTime));
        ao.setLocation("Location");
        ao.setShownAs(3);
        ao.setParentFolderID(fid2);
        ao.setIgnoreConflicts(true);
        int oid2 = AppointmentTest.insertAppointment(webCon, ao, TimeZone.getDefault(), "http://" + host, session);
        int[] repo = new int[]{oid1, fid1, oid2, fid2};
        LinkObject lo = new LinkObject();
        lo.setFirstFolder(fid1);
        lo.setFirstId(oid1);
        lo.setFirstType(7);
        lo.setSecondFolder(fid2);
        lo.setSecondId(oid2);
        lo.setSecondType(1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        JSONWriter jsonwriter = new JSONWriter((Writer)pw);
        jsonwriter.object();
        jsonwriter.key("id1").value((long)lo.getFirstId());
        jsonwriter.key("module1").value((long)lo.getFirstType());
        jsonwriter.key("folder1").value((long)lo.getFirstFolder());
        jsonwriter.key("id2").value((long)lo.getSecondId());
        jsonwriter.key("module2").value((long)lo.getSecondType());
        jsonwriter.key("folder2").value((long)lo.getSecondFolder());
        jsonwriter.endObject();
        pw.flush();
        JSONObject jResponse = null;
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "new");
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest("http://" + host + LINK_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        jResponse = new JSONObject(resp.getText());
        LinkTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)jResponse.toString());
        if (response.hasError()) {
            LinkTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        return repo;
    }

    public void testAll() throws Exception {
        int[] go = LinkTest.insertLink(this.getWebConversation(), this.getHostName(), this.getSessionId());
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", this.getSessionId());
        parameter.setParameter("action", "all");
        parameter.setParameter("folder", go[1]);
        parameter.setParameter("id", go[0]);
        parameter.setParameter("module", 7);
        GetMethodWebRequest req = new GetMethodWebRequest("http://" + this.getHostName() + LINK_URL + parameter.getURLParameters());
        WebResponse resp = this.getWebConversation().getResponse((WebRequest)req);
        LinkTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            LinkTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        LinkTest.assertEquals((int)200, (int)resp.getResponseCode());
        JSONArray data = (JSONArray)response.getData();
        for (int i = 0; i < data.length(); ++i) {
            JSONObject jo = data.getJSONObject(i);
            if (jo.getInt("id2") == go[2] && jo.getInt("folder2") == go[3] && jo.getInt("module2") == 1) continue;
            LinkTest.fail((String)"json error: OBJECT MISSMATCH");
        }
    }

    public void testDelete() throws Exception {
        JSONArray data;
        JSONArray jo;
        int[] go = LinkTest.insertLink(this.getWebConversation(), this.getHostName(), this.getSessionId());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        JSONWriter jsonwriter = new JSONWriter((Writer)pw);
        jsonwriter.object();
        JSONArray jo1 = new JSONArray();
        JSONArray jo2 = new JSONArray();
        jo2.put(0, go[2]);
        jo2.put(1, 1);
        jo2.put(2, go[3]);
        jo1.put(0, (Object)jo2);
        jsonwriter.key("data").value((Object)jo1);
        jsonwriter.endObject();
        pw.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", this.getSessionId());
        parameter.setParameter("action", "delete");
        parameter.setParameter("folder", go[1]);
        parameter.setParameter("id", go[0]);
        parameter.setParameter("module", 7);
        PutMethodWebRequest req = new PutMethodWebRequest("http://" + this.getHostName() + LINK_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = this.getWebConversation().getResponse((WebRequest)req);
        LinkTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            LinkTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        if ((jo = (data = (JSONArray)response.getData()).optJSONArray(0)) != null) {
            LinkTest.fail((String)"json error: DATA MISSMATCH");
        }
        LinkTest.assertEquals((int)200, (int)resp.getResponseCode());
    }

    public void testWrongDelete() throws Exception {
        JSONArray data;
        JSONArray jo;
        int[] go = LinkTest.insertLink(this.getWebConversation(), this.getHostName(), this.getSessionId());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        JSONWriter jsonwriter = new JSONWriter((Writer)pw);
        jsonwriter.object();
        JSONArray jo1 = new JSONArray();
        JSONArray jo2 = new JSONArray();
        jo2.put(0, go[2]);
        jo2.put(1, 1);
        jo2.put(2, go[3]);
        jo1.put(0, (Object)jo2);
        jsonwriter.key("data").value((Object)jo1);
        jsonwriter.endObject();
        pw.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", this.getSessionId());
        parameter.setParameter("action", "delete");
        parameter.setParameter("folder", go[1]);
        parameter.setParameter("id", go[0]);
        parameter.setParameter("module", 7);
        PutMethodWebRequest req = new PutMethodWebRequest("http://" + this.getHostName() + LINK_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = this.getWebConversation().getResponse((WebRequest)req);
        LinkTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response = Response.parse((String)resp.getText());
        if (response.hasError()) {
            LinkTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        if (null != (jo = (data = (JSONArray)response.getData()).optJSONArray(0))) {
            LinkTest.fail((String)"json error: DATA MISSMATCH");
        }
        baos = new ByteArrayOutputStream();
        pw = new PrintWriter(baos);
        jsonwriter = new JSONWriter((Writer)pw);
        jsonwriter.object();
        jsonwriter.key("data").value((Object)jo1);
        jsonwriter.endObject();
        pw.flush();
        bais = new ByteArrayInputStream(baos.toByteArray());
        URLParameter parameter2 = new URLParameter();
        parameter2.setParameter("session", this.getSessionId());
        parameter2.setParameter("action", "delete");
        parameter2.setParameter("folder", go[1]);
        parameter2.setParameter("id", go[0]);
        parameter2.setParameter("module", 7);
        req = new PutMethodWebRequest("http://" + this.getHostName() + LINK_URL + parameter2.getURLParameters(), (InputStream)bais, "text/javascript");
        resp = this.getWebConversation().getResponse((WebRequest)req);
        LinkTest.assertEquals((int)200, (int)resp.getResponseCode());
        Response response2 = Response.parse((String)resp.getText());
        data = (JSONArray)response2.getData();
        jo = data.getJSONArray(0);
        if (jo.getInt(0) != go[2] || jo.getInt(1) != 1 || jo.getInt(2) != go[3]) {
            LinkTest.fail((String)"json error: DATA MISSMATCH");
        }
        LinkTest.assertEquals((int)200, (int)resp.getResponseCode());
    }
}

