/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.container.Response;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class ConfigJumpTest
extends AbstractAJAXTest {
    private static final Log LOG = LogFactory.getLog(ConfigJumpTest.class);
    private static final String CONTROL_URL = "/ajax/control";

    public ConfigJumpTest(String name) {
        super(name);
    }

    public void testReadSettings() throws Throwable {
        URL control = ConfigJumpTest.readURL(this.getWebConversation(), this.getHostName(), this.getSessionId());
        ConfigJumpTest.assertTrue((String)"Got no value from server.", (control.toString().length() > 0 ? 1 : 0) != 0);
    }

    public static URL readURL(WebConversation conversation, String hostName, String sessionId) throws IOException, SAXException, JSONException {
        LOG.trace((Object)"Reading control center URL.");
        GetMethodWebRequest req = new GetMethodWebRequest("http://" + hostName + CONTROL_URL);
        req.setParameter("session", sessionId);
        WebResponse resp = conversation.getResponse((WebRequest)req);
        ConfigJumpTest.assertEquals((String)"Response code is not okay.", (int)200, (int)resp.getResponseCode());
        String body = resp.getText();
        LOG.trace((Object)("Response body: \"" + body + "\""));
        Response response = Response.parse((String)body);
        ConfigJumpTest.assertFalse((String)response.getErrorMessage(), (boolean)response.hasError());
        return new URL((String)response.getData());
    }
}

