/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.contact.ContactService;
import com.openexchange.contacts.json.mapping.ContactMapper;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.Type;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.java.Streams;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAdminHelper;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.openexchange.user.UserService;
import com.openexchange.user.json.actions.AbstractUserAction;
import com.openexchange.user.json.field.UserField;
import com.openexchange.user.json.mapping.UserMapper;
import com.openexchange.user.json.services.ServiceRegistry;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Locale;
import javax.activation.MimetypesFileTypeMap;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="update", description="Update a user.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the updated user."), @Parameter(name="timestamp", type=Type.NUMBER, description="Timestamp of the updated user. If the user was modified after the specified timestamp, then the update must fail.")}, requestBody="User object as described in Common object data, Detailed contact data and Detailed user data. Only modified fields are present. Note: \"timezone\" and \"locale\" are the only fields from Detailed user data which are allowed to be updated.", responseDescription="Response with timestamp: An empty object.")
public final class UpdateAction
extends AbstractUserAction {
    public static final String ACTION = "update";
    private static ContactField[] CONTACT_FIELDS;
    private static UserField[] USER_FIELDS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {
        try {
            DatabaseService service;
            String displayName;
            boolean containsImage = request.hasUploads();
            int id = UpdateAction.checkIntParameter("id", request);
            Date clientLastModified = new Date(UpdateAction.checkLongParameter("timestamp", request));
            UserService userService = (UserService)ServiceRegistry.getInstance().getService(UserService.class, true);
            User storageUser = userService.getUser(id, session.getContext());
            int contactId = storageUser.getContactId();
            String timeZoneID = request.getParameter("timezone");
            if (null == timeZoneID) {
                timeZoneID = session.getUser().getTimeZone();
            }
            JSONObject jData = containsImage ? new JSONObject(request.getUploadEvent().getFormField("json")) : (JSONObject)request.getData();
            Contact parsedUserContact = (Contact)ContactMapper.getInstance().deserialize(jData, (Enum[])CONTACT_FIELDS, timeZoneID);
            parsedUserContact.setObjectID(contactId);
            jData.put(UserField.ID.getName(), id);
            User parsedUser = (User)UserMapper.getInstance().deserialize(jData, USER_FIELDS, timeZoneID);
            if (containsImage) {
                UpdateAction.setImageData(request, parsedUserContact);
            }
            ContactService contactService = (ContactService)ServiceRegistry.getInstance().getService(ContactService.class, true);
            if (parsedUserContact.containsDisplayName() && null != (displayName = parsedUserContact.getDisplayName())) {
                if (UpdateAction.isEmpty(displayName)) {
                    parsedUserContact.removeDisplayName();
                } else {
                    Contact storageContact = contactService.getUser((Session)session, id);
                    if (displayName.equals(storageContact.getDisplayName())) {
                        parsedUserContact.removeDisplayName();
                    }
                }
            }
            contactService.updateUser((Session)session, Integer.toString(6), Integer.toString(contactId), parsedUserContact, clientLastModified);
            String parsedTimeZone = parsedUser.getTimeZone();
            Locale parsedLocale = parsedUser.getLocale();
            if (null != parsedTimeZone || null != parsedLocale) {
                if (null == parsedTimeZone) {
                    UserMapper.getInstance().get(UserField.TIME_ZONE).copy((Object)storageUser, (Object)parsedUser);
                }
                if (null == parsedLocale) {
                    UserMapper.getInstance().get(UserField.LOCALE).copy((Object)storageUser, (Object)parsedUser);
                }
                userService.updateUser(parsedUser, session.getContext());
            }
            if (parsedUserContact.containsDisplayName() && null != parsedUserContact.getDisplayName() && null != (service = (DatabaseService)ServiceRegistry.getInstance().getService(DatabaseService.class))) {
                int contextId = session.getContextId();
                Connection con = null;
                boolean rollback = false;
                try {
                    con = service.getWritable(contextId);
                    con.setAutoCommit(false);
                    rollback = true;
                    int[] changedfields = new int[]{500};
                    OXFolderAdminHelper.propagateUserModification((int)id, (int[])changedfields, (long)System.currentTimeMillis(), (Connection)con, (Connection)con, (int)contextId);
                    con.commit();
                    rollback = false;
                }
                catch (Exception ignore) {
                }
                finally {
                    if (null != con) {
                        if (rollback) {
                            Databases.rollback((Connection)con);
                        }
                        Databases.autocommit((Connection)con);
                        service.backWritable(contextId, con);
                    }
                }
            }
            return new AJAXRequestResult((Object)new JSONObject(), parsedUserContact.getLastModified());
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setImageData(AJAXRequestData request, Contact contact) throws OXException {
        UploadEvent uploadEvent = null;
        try {
            uploadEvent = request.getUploadEvent();
            UploadFile file = uploadEvent.getUploadFileByFieldName("file");
            if (null == file) {
                throw AjaxExceptionCodes.NO_UPLOAD_IMAGE.create();
            }
            UpdateAction.setImageData(contact, file);
        }
        finally {
            if (null != uploadEvent) {
                uploadEvent.cleanUp();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setImageData(Contact contact, UploadFile file) throws OXException {
        UpdateAction.checkIsImageFile(file);
        FileInputStream fis = null;
        UnsynchronizedByteArrayOutputStream outputStream = null;
        try {
            fis = new FileInputStream(file.getTmpFile());
            outputStream = new UnsynchronizedByteArrayOutputStream((int)file.getSize());
            byte[] buf = new byte[2048];
            int len = -1;
            while ((len = fis.read(buf)) != -1) {
                outputStream.write(buf, 0, len);
            }
            contact.setImage1(outputStream.toByteArray());
            contact.setImageContentType(file.getContentType());
        }
        catch (FileNotFoundException e) {
            try {
                throw AjaxExceptionCodes.NO_UPLOAD_IMAGE.create((Throwable)e, new Object[0]);
                catch (IOException e2) {
                    throw AjaxExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e2, new Object[]{"I/O error while reading uploaded contact image."});
                }
            }
            catch (Throwable throwable) {
                Streams.close(outputStream);
                Streams.close((Closeable)fis);
                throw throwable;
            }
        }
        Streams.close((Closeable)outputStream);
        Streams.close((Closeable)fis);
    }

    private static void checkIsImageFile(UploadFile file) throws OXException {
        if (null == file) {
            throw AjaxExceptionCodes.NO_UPLOAD_IMAGE.create();
        }
        String contentType = file.getContentType();
        if (UpdateAction.isImageContentType(contentType)) {
            return;
        }
        String mimeType = null;
        if (null != file.getPreparedFileName() && UpdateAction.isImageContentType(mimeType = new MimetypesFileTypeMap().getContentType(file.getPreparedFileName()))) {
            return;
        }
        String readableType = null == contentType ? (null == mimeType ? "application/unknown" : mimeType) : contentType;
        throw AjaxExceptionCodes.NO_IMAGE_FILE.create(new Object[]{file.getPreparedFileName(), readableType});
    }

    private static boolean isImageContentType(String contentType) {
        return null != contentType && contentType.toLowerCase().startsWith("image");
    }

    static {
        EnumSet<ContactField> set = EnumSet.noneOf(ContactField.class);
        set.add(ContactField.DISPLAY_NAME);
        set.add(ContactField.SUR_NAME);
        set.add(ContactField.GIVEN_NAME);
        set.add(ContactField.MIDDLE_NAME);
        set.add(ContactField.SUFFIX);
        set.add(ContactField.TITLE);
        set.add(ContactField.STREET_HOME);
        set.add(ContactField.POSTAL_CODE_HOME);
        set.add(ContactField.CITY_HOME);
        set.add(ContactField.STATE_HOME);
        set.add(ContactField.COUNTRY_HOME);
        set.add(ContactField.MARITAL_STATUS);
        set.add(ContactField.NUMBER_OF_CHILDREN);
        set.add(ContactField.PROFESSION);
        set.add(ContactField.NICKNAME);
        set.add(ContactField.SPOUSE_NAME);
        set.add(ContactField.NOTE);
        set.add(ContactField.COMPANY);
        set.add(ContactField.DEPARTMENT);
        set.add(ContactField.POSITION);
        set.add(ContactField.EMPLOYEE_TYPE);
        set.add(ContactField.ROOM_NUMBER);
        set.add(ContactField.STREET_BUSINESS);
        set.add(ContactField.POSTAL_CODE_BUSINESS);
        set.add(ContactField.CITY_BUSINESS);
        set.add(ContactField.STATE_BUSINESS);
        set.add(ContactField.COUNTRY_BUSINESS);
        set.add(ContactField.NUMBER_OF_EMPLOYEE);
        set.add(ContactField.SALES_VOLUME);
        set.add(ContactField.TAX_ID);
        set.add(ContactField.COMMERCIAL_REGISTER);
        set.add(ContactField.BRANCHES);
        set.add(ContactField.BUSINESS_CATEGORY);
        set.add(ContactField.INFO);
        set.add(ContactField.MANAGER_NAME);
        set.add(ContactField.ASSISTANT_NAME);
        set.add(ContactField.STREET_OTHER);
        set.add(ContactField.POSTAL_CODE_OTHER);
        set.add(ContactField.CITY_OTHER);
        set.add(ContactField.STATE_OTHER);
        set.add(ContactField.COUNTRY_OTHER);
        set.add(ContactField.TELEPHONE_ASSISTANT);
        set.add(ContactField.TELEPHONE_BUSINESS1);
        set.add(ContactField.TELEPHONE_BUSINESS2);
        set.add(ContactField.FAX_BUSINESS);
        set.add(ContactField.TELEPHONE_CALLBACK);
        set.add(ContactField.TELEPHONE_CAR);
        set.add(ContactField.TELEPHONE_COMPANY);
        set.add(ContactField.TELEPHONE_HOME1);
        set.add(ContactField.TELEPHONE_HOME2);
        set.add(ContactField.FAX_HOME);
        set.add(ContactField.TELEPHONE_ISDN);
        set.add(ContactField.CELLULAR_TELEPHONE1);
        set.add(ContactField.CELLULAR_TELEPHONE2);
        set.add(ContactField.TELEPHONE_OTHER);
        set.add(ContactField.FAX_OTHER);
        set.add(ContactField.TELEPHONE_PAGER);
        set.add(ContactField.TELEPHONE_PRIMARY);
        set.add(ContactField.TELEPHONE_RADIO);
        set.add(ContactField.TELEPHONE_TELEX);
        set.add(ContactField.TELEPHONE_TTYTDD);
        set.add(ContactField.INSTANT_MESSENGER1);
        set.add(ContactField.INSTANT_MESSENGER2);
        set.add(ContactField.TELEPHONE_IP);
        set.add(ContactField.EMAIL1);
        set.add(ContactField.EMAIL2);
        set.add(ContactField.EMAIL3);
        set.add(ContactField.URL);
        set.add(ContactField.CATEGORIES);
        set.add(ContactField.USERFIELD01);
        set.add(ContactField.USERFIELD02);
        set.add(ContactField.USERFIELD03);
        set.add(ContactField.USERFIELD04);
        set.add(ContactField.USERFIELD05);
        set.add(ContactField.USERFIELD06);
        set.add(ContactField.USERFIELD07);
        set.add(ContactField.USERFIELD08);
        set.add(ContactField.USERFIELD09);
        set.add(ContactField.USERFIELD10);
        set.add(ContactField.USERFIELD11);
        set.add(ContactField.USERFIELD12);
        set.add(ContactField.USERFIELD13);
        set.add(ContactField.USERFIELD14);
        set.add(ContactField.USERFIELD15);
        set.add(ContactField.USERFIELD16);
        set.add(ContactField.USERFIELD17);
        set.add(ContactField.USERFIELD18);
        set.add(ContactField.USERFIELD19);
        set.add(ContactField.USERFIELD20);
        set.add(ContactField.BIRTHDAY);
        set.add(ContactField.ANNIVERSARY);
        set.add(ContactField.COLOR_LABEL);
        set.add(ContactField.DEFAULT_ADDRESS);
        set.add(ContactField.YOMI_FIRST_NAME);
        set.add(ContactField.YOMI_LAST_NAME);
        set.add(ContactField.YOMI_COMPANY);
        set.add(ContactField.HOME_ADDRESS);
        set.add(ContactField.BUSINESS_ADDRESS);
        set.add(ContactField.OTHER_ADDRESS);
        CONTACT_FIELDS = set.toArray(new ContactField[0]);
        USER_FIELDS = new UserField[]{UserField.ID, UserField.LOCALE, UserField.TIME_ZONE};
    }
}

