/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.helpers.FilteredSubscriptionSourceDiscoveryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class CompositeSubscriptionSourceDiscoveryService
implements SubscriptionSourceDiscoveryService {
    private final List<SubscriptionSourceDiscoveryService> services = new ArrayList<SubscriptionSourceDiscoveryService>();

    @Override
    public SubscriptionSource getSource(String identifier) {
        SubscriptionSource current = null;
        for (SubscriptionSourceDiscoveryService subDiscoverer : this.services) {
            if (!subDiscoverer.knowsSource(identifier)) continue;
            SubscriptionSource source = subDiscoverer.getSource(identifier);
            if (current != null && current.getPriority() >= source.getPriority()) continue;
            current = source;
        }
        return current;
    }

    @Override
    public List<SubscriptionSource> getSources(int folderModule) {
        HashMap<String, SubscriptionSource> allSources = new HashMap<String, SubscriptionSource>();
        for (SubscriptionSourceDiscoveryService subDiscoverer : this.services) {
            List<SubscriptionSource> sources = subDiscoverer.getSources(folderModule);
            for (SubscriptionSource subscriptionSource : sources) {
                SubscriptionSource previousSource = (SubscriptionSource)allSources.get(subscriptionSource.getId());
                if (previousSource != null && previousSource.getPriority() >= subscriptionSource.getPriority()) continue;
                allSources.put(subscriptionSource.getId(), subscriptionSource);
            }
        }
        ArrayList<SubscriptionSource> sources = new ArrayList<SubscriptionSource>(allSources.values());
        Collections.sort(sources, new Comparator<SubscriptionSource>(){

            @Override
            public int compare(SubscriptionSource o1, SubscriptionSource o2) {
                if (o1.getDisplayName() != null && o2.getDisplayName() != null) {
                    return o1.getDisplayName().compareTo(o2.getDisplayName());
                }
                return o1.getDisplayName() == null ? -1 : 1;
            }
        });
        return sources;
    }

    @Override
    public List<SubscriptionSource> getSources() {
        return this.getSources(-1);
    }

    @Override
    public boolean knowsSource(String identifier) {
        for (SubscriptionSourceDiscoveryService subDiscoverer : this.services) {
            if (!subDiscoverer.knowsSource(identifier)) continue;
            return true;
        }
        return false;
    }

    public void addSubscriptionSourceDiscoveryService(SubscriptionSourceDiscoveryService service) {
        this.services.add(service);
    }

    public void removeSubscriptionSourceDiscoveryService(SubscriptionSourceDiscoveryService service) {
        this.services.remove(service);
    }

    @Override
    public SubscriptionSource getSource(Context context, int subscriptionId) throws OXException {
        for (SubscriptionSourceDiscoveryService subDiscoverer : this.services) {
            SubscriptionSource source = subDiscoverer.getSource(context, subscriptionId);
            if (source == null) continue;
            return source;
        }
        return null;
    }

    public void clear() {
        this.services.clear();
    }

    @Override
    public SubscriptionSourceDiscoveryService filter(int user, int context) throws OXException {
        return new FilteredSubscriptionSourceDiscoveryService(user, context, this);
    }
}

