/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import java.io.OutputStream;
import java.util.Date;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Verifier;
import org.jdom2.output.XMLOutputter;

public class DataWriter {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(DataWriter.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();
    public static final int ACTION_MODIFIED = 1;
    public static final int ACTION_DELETE = 2;
    public static final int ACTION_LIST = 3;
    private static final Namespace dav = Namespace.getNamespace((String)"D", (String)"DAV:");
    public static final Namespace namespace = Namespace.getNamespace((String)"ox", (String)"http://www.open-xchange.org");
    protected Session sessionObj;
    protected Context ctx;
    protected User userObj;

    protected void writeResponseElement(Element e_prop, int object_id, int status, String description, XMLOutputter xo, OutputStream os) throws Exception {
        Element e_response = new Element("response", dav);
        e_response.addNamespaceDeclaration(Namespace.getNamespace((String)"ox", (String)"http://www.open-xchange.org"));
        e_response.addContent((Content)new Element("href", dav).addContent(Integer.toString(object_id)));
        Element e_propstat = new Element("propstat", dav);
        e_response.addContent((Content)e_propstat);
        e_propstat.addContent((Content)e_prop);
        e_propstat.addContent((Content)new Element("status", dav).addContent(Integer.toString(status)));
        e_propstat.addContent((Content)new Element("responsedescription", dav).addContent(DataWriter.correctCharacterData(description)));
        xo.output(e_response, os);
        os.flush();
    }

    protected void writeDataElements(DataObject dataobject, Element e_prop) {
        if (dataobject.containsCreatedBy()) {
            DataWriter.addElement("created_by", dataobject.getCreatedBy(), e_prop);
        }
        if (dataobject.containsCreationDate()) {
            DataWriter.addElement("creation_time", dataobject.getCreationDate(), e_prop);
        }
        if (dataobject.containsModifiedBy()) {
            DataWriter.addElement("modified_by", dataobject.getModifiedBy(), e_prop);
        }
        if (dataobject.containsLastModified()) {
            DataWriter.addElement("last_modified", dataobject.getLastModified(), e_prop);
        }
        if (dataobject.containsObjectID()) {
            DataWriter.addElement("object_id", dataobject.getObjectID(), e_prop);
        }
    }

    public static Element addElement(String name, String value, Element parent) {
        if (value != null) {
            Element e = new Element(name, "ox", "http://www.open-xchange.org");
            e.addContent(DataWriter.correctCharacterData(value));
            parent.addContent((Content)e);
            return e;
        }
        return null;
    }

    public static Element addElement(String name, Date value, Element parent) {
        if (value != null) {
            Element e = new Element(name, "ox", "http://www.open-xchange.org");
            e.addContent(Long.toString(value.getTime()));
            parent.addContent((Content)e);
            return e;
        }
        return null;
    }

    public static Element addElement(String name, int value, Element parent) {
        Element e = new Element(name, "ox", "http://www.open-xchange.org");
        e.addContent(Integer.toString(value));
        parent.addContent((Content)e);
        return e;
    }

    public static Element addElement(String name, float value, Element parent) throws Exception {
        Element e = new Element(name, "ox", "http://www.open-xchange.org");
        e.addContent(Float.toString(value));
        parent.addContent((Content)e);
        return e;
    }

    public static Element addElement(String name, long value, Element parent) throws Exception {
        Element e = new Element(name, "ox", "http://www.open-xchange.org");
        e.addContent(Long.toString(value));
        parent.addContent((Content)e);
        return e;
    }

    public static Element addElement(String name, boolean value, Element parent) {
        Element e = new Element(name, "ox", "http://www.open-xchange.org");
        if (value) {
            e.addContent("true");
        } else {
            e.addContent("false");
        }
        parent.addContent((Content)e);
        return e;
    }

    public static final String correctCharacterData(String text) {
        if (text == null) {
            if (DEBUG) {
                LOG.debug((Object)"null is not a legal XML value");
            }
            return "";
        }
        int length = text.length();
        StringBuilder retvalBuilder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int ch = text.charAt(i);
            if (ch >= 55296 && ch <= 56319) {
                if (++i < length) {
                    char low = text.charAt(i);
                    if (low >= '\udc00' && low <= '\udfff') {
                        if (Verifier.isXMLCharacter((int)(ch = 65536 + (ch - 55296) * 1024 + (low - 56320)))) {
                            retvalBuilder.append((char)ch);
                            continue;
                        }
                        if (!DEBUG) continue;
                        LOG.debug((Object)("0x" + Integer.toHexString(ch) + " is not a legal XML character"));
                        continue;
                    }
                    if (!DEBUG) continue;
                    LOG.debug((Object)"illegal surrogate pair");
                    continue;
                }
                if (!DEBUG) continue;
                LOG.debug((Object)"truncated surrogate pair");
                continue;
            }
            if (Verifier.isXMLCharacter((int)ch)) {
                retvalBuilder.append((char)ch);
                continue;
            }
            if (!DEBUG) continue;
            LOG.debug((Object)("0x" + Integer.toHexString(ch) + " is not a legal XML character"));
        }
        return retvalBuilder.toString();
    }

    protected static String getErrorMessage(String message, String arg) {
        return String.format(message, arg);
    }

    protected static String getErrorMessage(String message, int errorCode) {
        return DataWriter.getErrorMessage(message, Integer.toString(errorCode));
    }
}

