/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.valuedefinitions.rfc2445;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.ValueDefinition;
import com.openexchange.tools.versit.valuedefinitions.rfc2425.DateTimeValueDefinition;
import com.openexchange.tools.versit.valuedefinitions.rfc2445.PositiveDurationValueDefinition;
import com.openexchange.tools.versit.values.DateTimeValue;
import com.openexchange.tools.versit.values.DurationValue;
import com.openexchange.tools.versit.values.PeriodValue;
import java.io.IOException;

public class PeriodValueDefinition
extends ValueDefinition {
    public static final ValueDefinition Default = new PeriodValueDefinition();

    @Override
    public Object createValue(StringScanner s, Property property) throws IOException {
        PeriodValue period = new PeriodValue();
        period.Start = (DateTimeValue)DateTimeValueDefinition.Default.createValue(s, property);
        if (s.peek != 47) {
            throw new IOException("Period expected");
        }
        s.read();
        if (s.peek == 43 || s.peek == 80) {
            period.End = (DateTimeValue)DateTimeValueDefinition.Default.createValue(s, property);
        } else {
            period.Duration = (DurationValue)PositiveDurationValueDefinition.Default.createValue(s, property);
        }
        return period;
    }

    @Override
    public String writeValue(Object value) {
        PeriodValue period = (PeriodValue)value;
        String end = null;
        if (period.End != null) {
            end = DateTimeValueDefinition.Default.writeValue(period.End);
        } else if (period.Duration != null) {
            end = PositiveDurationValueDefinition.Default.writeValue(period.Duration);
        }
        return DateTimeValueDefinition.Default.writeValue(period.Start) + '/' + end;
    }
}

