/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.old;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.old.OldIntegerPropertyDefinition;
import com.openexchange.tools.versit.old.OldParamDefinition;
import java.io.IOException;

public class OldPriorityPropertyDefinition
extends OldIntegerPropertyDefinition {
    public OldPriorityPropertyDefinition(String[] paramNames, OldParamDefinition[] params) {
        super(paramNames, params);
    }

    @Override
    protected Object parseValue(Property property, StringScanner s) throws IOException {
        int[] mapping = new int[]{1, 3, 5, 7, 9};
        int prio = Integer.parseInt(s.getRest());
        if (prio < 1 || prio > 5) {
            throw new VersitException(s, "Invalid priority: " + prio);
        }
        return mapping[prio - 1];
    }

    @Override
    protected String writeValue(Property property, Object value) {
        String[] mapping = new String[]{"1", "1", "2", "2", "3", "4", "4", "5", "5"};
        int prio = (Integer)value;
        if (prio < 1 || prio > 9) {
            return "0";
        }
        return mapping[prio - 1];
    }
}

