/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.pipesnfilters.internal;

import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.tools.pipesnfilters.DataSource;
import com.openexchange.tools.pipesnfilters.Filter;
import com.openexchange.tools.pipesnfilters.internal.FilterTask;
import com.openexchange.tools.pipesnfilters.internal.Pipe;
import java.util.Collection;
import java.util.Iterator;

class CollectionDataSource<I>
implements DataSource<I> {
    private final ThreadPoolService threadPool;
    private final Iterator<I> iter;
    private final int blockSize = 100;

    public CollectionDataSource(ThreadPoolService threadPool, Collection<I> source) {
        this.threadPool = threadPool;
        this.iter = source.iterator();
    }

    @Override
    public int getData(Collection<I> col) {
        int count;
        for (count = 0; count < 100 && this.iter.hasNext(); ++count) {
            col.add(this.iter.next());
        }
        return count;
    }

    @Override
    public boolean hasData() {
        return this.iter.hasNext();
    }

    @Override
    public <O> DataSource<O> addFilter(Filter<I, O> filter) {
        Pipe pipe = new Pipe(this.threadPool);
        FilterTask<I, O> task = new FilterTask<I, O>(this, filter, pipe);
        this.threadPool.submit(task);
        return pipe;
    }
}

