/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images.transformations;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.jpeg.JpegDirectory;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.images.ImageTransformations;
import com.openexchange.tools.images.ScaleType;
import com.openexchange.tools.images.impl.ImageInformation;
import com.openexchange.tools.images.transformations.CropTransformation;
import com.openexchange.tools.images.transformations.ImageTransformation;
import com.openexchange.tools.images.transformations.RotateTransformation;
import com.openexchange.tools.images.transformations.ScaleTransformation;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.logging.Log;

public class ImageTransformationsImpl
implements ImageTransformations {
    private static Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ImageTransformationsImpl.class));
    private final InputStream sourceImageStream;
    private final List<ImageTransformation> transformations;
    private BufferedImage sourceImage;
    private Metadata metadata;
    private boolean compress;

    private ImageTransformationsImpl(BufferedImage sourceImage, InputStream sourceImageStream) {
        this.sourceImage = sourceImage;
        this.sourceImageStream = sourceImageStream;
        this.transformations = new ArrayList<ImageTransformation>();
    }

    public ImageTransformationsImpl(BufferedImage sourceImage) {
        this(sourceImage, null);
    }

    public ImageTransformationsImpl(InputStream sourceImageStream) throws IOException {
        this(null, sourceImageStream);
    }

    @Override
    public ImageTransformations rotate() {
        this.transformations.add(new RotateTransformation());
        return this;
    }

    @Override
    public ImageTransformations scale(int maxWidth, int maxHeight, ScaleType scaleType) {
        this.transformations.add(new ScaleTransformation(maxWidth, maxHeight, scaleType));
        return this;
    }

    @Override
    public ImageTransformations crop(int x, int y, int width, int height) {
        this.transformations.add(new CropTransformation(x, y, width, height));
        return this;
    }

    @Override
    public ImageTransformations compress() {
        this.compress = true;
        return this;
    }

    @Override
    public BufferedImage getImage() throws IOException {
        if (!this.needsTransformation(null) && null != this.sourceImage) {
            return this.sourceImage;
        }
        return this.getImage(null);
    }

    @Override
    public byte[] getBytes(String formatName) throws IOException {
        String imageFormat = ImageTransformationsImpl.getImageFormat(formatName);
        return this.innerGetBytes(imageFormat);
    }

    private byte[] innerGetBytes(String imageFormat) throws IOException {
        return this.write(this.getImage(imageFormat), imageFormat);
    }

    @Override
    public InputStream getInputStream(String formatName) throws IOException {
        String imageFormat = ImageTransformationsImpl.getImageFormat(formatName);
        if (!this.needsTransformation(imageFormat) && null != this.sourceImageStream) {
            return this.sourceImageStream;
        }
        byte[] bytes = this.innerGetBytes(imageFormat);
        return null == bytes ? null : Streams.newByteArrayInputStream((byte[])bytes);
    }

    private boolean needsTransformation(String formatName) {
        if (!ImageTransformationsImpl.canRead(formatName)) {
            return false;
        }
        for (ImageTransformation transformation : this.transformations) {
            if (!transformation.supports(formatName)) continue;
            return true;
        }
        return false;
    }

    private BufferedImage getImage(String formatName) throws IOException {
        BufferedImage image = this.getSourceImage(formatName);
        if (null != image && image.getHeight() > 3 && image.getWidth() > 3) {
            ImageInformation imageInformation = null != this.metadata ? ImageTransformationsImpl.getImageInformation(this.metadata) : null;
            for (ImageTransformation transformation : this.transformations) {
                if (!transformation.supports(formatName)) continue;
                image = transformation.perform(image, imageInformation);
            }
        }
        return image;
    }

    private BufferedImage getSourceImage(String formatName) throws IOException {
        if (null == this.sourceImage && null != this.sourceImageStream) {
            this.sourceImage = this.needsMetadata(formatName) ? this.readAndExtractMetadata(this.sourceImageStream) : this.read(this.sourceImageStream);
        }
        return this.sourceImage;
    }

    private boolean needsMetadata(String formatName) {
        if (null == formatName || 0 == formatName.length()) {
            return false;
        }
        for (ImageTransformation transformation : this.transformations) {
            if (!transformation.supports(formatName) || !transformation.needsImageInformation()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] write(BufferedImage image, String formatName) throws IOException {
        byte[] byArray;
        if (null == image) {
            return null;
        }
        UnsynchronizedByteArrayOutputStream outputStream = null;
        try {
            outputStream = new UnsynchronizedByteArrayOutputStream(8192);
            if (this.needsCompression(formatName)) {
                ImageTransformationsImpl.writeCompressed(image, formatName, (OutputStream)outputStream);
            } else {
                ImageTransformationsImpl.write(image, formatName, (OutputStream)outputStream);
            }
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            Streams.close(outputStream);
            throw throwable;
        }
        Streams.close((Closeable)outputStream);
        return byArray;
    }

    private boolean needsCompression(String formatName) {
        return this.compress && null != formatName && "jpeg".equalsIgnoreCase(formatName) || "jpg".equalsIgnoreCase(formatName);
    }

    private static void write(BufferedImage image, String formatName, OutputStream output) throws IOException {
        if (!ImageIO.write((RenderedImage)image, formatName, output)) {
            throw new IOException("no appropriate writer found for " + formatName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCompressed(BufferedImage image, String formatName, OutputStream output) throws IOException {
        ImageWriter writer = null;
        ImageInputStream imageOutputStream = null;
        try {
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
            if (!(null != iter && iter.hasNext() || null != (iter = ImageIO.getImageWritersByMIMEType(formatName)) && iter.hasNext())) {
                throw new IOException("No image writer for format " + formatName);
            }
            writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            ImageTransformationsImpl.adjustCompressionParams(iwp);
            imageOutputStream = ImageIO.createImageOutputStream(output);
            writer.setOutput(imageOutputStream);
            IIOImage iioImage = new IIOImage(image, null, null);
            writer.write(null, iioImage, iwp);
        }
        finally {
            if (null != writer) {
                writer.dispose();
            }
            if (null != imageOutputStream) {
                imageOutputStream.close();
            }
        }
    }

    private static void adjustCompressionParams(ImageWriteParam parameters) {
        try {
            parameters.setCompressionMode(2);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        try {
            parameters.setProgressiveMode(1);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        try {
            parameters.setCompressionQuality(0.8f);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage read(InputStream inputStream) throws IOException {
        try {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (IllegalArgumentException e) {
            LOG.debug((Object)"error reading image from stream", (Throwable)e);
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            Streams.close((Closeable)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readAndExtractMetadata(InputStream inputStream) throws IOException {
        ManagedFile managedFile = null;
        try {
            ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            managedFile = mfm.createManagedFile(inputStream);
            try {
                this.metadata = ImageMetadataReader.readMetadata((BufferedInputStream)new BufferedInputStream(managedFile.getInputStream()), (boolean)false);
            }
            catch (ImageProcessingException e) {
                LOG.warn((Object)"error getting metadata", (Throwable)e);
            }
            BufferedImage bufferedImage = ImageIO.read(managedFile.getInputStream());
            return bufferedImage;
        }
        catch (OXException e) {
            throw new IOException("error accessing managed file", e);
        }
        catch (IllegalArgumentException e) {
            LOG.debug((Object)"error reading image from stream", (Throwable)e);
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            if (managedFile != null) {
                try {
                    managedFile.delete();
                }
                catch (Exception x) {}
            }
        }
    }

    private static ImageInformation getImageInformation(Metadata metadata) {
        if (null == metadata) {
            return null;
        }
        int orientation = 1;
        int width = 0;
        int height = 0;
        try {
            JpegDirectory jpegDirectory;
            Directory directory = metadata.getDirectory(ExifIFD0Directory.class);
            if (null != directory) {
                orientation = directory.getInt(274);
            }
            if (null != (jpegDirectory = (JpegDirectory)metadata.getDirectory(JpegDirectory.class))) {
                width = jpegDirectory.getImageWidth();
                height = jpegDirectory.getImageHeight();
            }
        }
        catch (MetadataException e) {
            LOG.debug((Object)"Unable to retrieve image information.", (Throwable)e);
            return null;
        }
        return new ImageInformation(orientation, width, height);
    }

    private static String getImageFormat(String value) {
        int idx;
        if (null == value) {
            LOG.debug((Object)"No format name specified, falling back to 'jpeg'.");
            return "jpeg";
        }
        String val = value;
        if (val.toLowerCase().startsWith("image/")) {
            val = val.substring(6);
        }
        if (0 < (idx = val.indexOf(59))) {
            val = val.substring(0, idx);
        }
        if ("pjpeg".equals(val)) {
            LOG.debug((Object)("Assuming 'jpeg' for image format " + val));
            return "jpeg";
        }
        if ("x-png".equals(val)) {
            LOG.debug((Object)("Assuming 'png' for image format " + val));
            return "png";
        }
        if ("x-ms-bmp".equals(val)) {
            LOG.debug((Object)("Assuming 'bmp' for image format " + val));
            return "bmp";
        }
        return val;
    }

    private static boolean canRead(String formatName) {
        String tmp = ImageTransformationsImpl.toLowerCase(formatName);
        if ("vnd.microsoft.icon".equals(tmp) || "x-icon".equals(tmp)) {
            return false;
        }
        for (String readerFormatName : ImageIO.getReaderFormatNames()) {
            if (!ImageTransformationsImpl.toLowerCase(readerFormatName).equals(tmp)) continue;
            return true;
        }
        return false;
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }
}

