/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.codec;

import com.openexchange.java.Charsets;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;

public final class QuotedPrintable {
    private static final String ENCODING_QP = "QUOTED-PRINTABLE";
    private static final String ENCODE_Q = "Q";
    private static final String REGEX_PREFIX = "((\\?=)? ?=\\?";
    private static final String REGEX_APPENDIX = "\\?Q\\?)|(\\?=)";
    private static final String[] RPL = new String[]{"_", "\\r", "\\n"};
    private static final String[] SUB = new String[]{" ", "=0D", "=0A"};

    private QuotedPrintable() {
    }

    public static String encodeString(String originalStr, String charset) throws UnsupportedEncodingException {
        String encStr = MimeUtility.encodeText((String)originalStr, (String)charset, (String)ENCODE_Q);
        encStr = encStr.replaceAll(REGEX_PREFIX + charset + REGEX_APPENDIX, "");
        for (int i = 0; i < RPL.length; ++i) {
            encStr = encStr.replaceAll(RPL[i], SUB[i]);
        }
        return encStr;
    }

    public static String decodeString(String quotedPrintableStr, String charset) throws IOException, MessagingException {
        InputStream inStream = MimeUtility.decode((InputStream)new UnsynchronizedByteArrayInputStream(quotedPrintableStr.getBytes(charset)), (String)ENCODING_QP);
        UnsynchronizedByteArrayOutputStream decodedBytes = new UnsynchronizedByteArrayOutputStream();
        int k = -1;
        byte[] buffer = new byte[512];
        while ((k = inStream.read(buffer)) > 0) {
            decodedBytes.write(buffer, 0, k);
        }
        return new String(decodedBytes.toByteArray(), Charsets.forName((String)charset));
    }
}

