/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.session.SessionHolderExtended;

public class ThreadLocalSessionHolder
implements SessionHolderExtended {
    private static final ThreadLocalSessionHolder INSTANCE = new ThreadLocalSessionHolder();
    private final ThreadLocal<ServerSession> session = new ThreadLocal();

    public static ThreadLocalSessionHolder getInstance() {
        return INSTANCE;
    }

    private ThreadLocalSessionHolder() {
    }

    public void setSession(ServerSession serverSession) {
        this.session.set(serverSession);
        if (LogProperties.isEnabled() && serverSession != null) {
            Props properties = LogProperties.getLogProperties();
            properties.put(LogProperties.Name.SESSION_SESSION_ID, (Object)serverSession.getSessionID());
            properties.put(LogProperties.Name.SESSION_USER_ID, (Object)serverSession.getUserId());
            properties.put(LogProperties.Name.SESSION_CONTEXT_ID, (Object)serverSession.getContextId());
            String client = serverSession.getClient();
            properties.put(LogProperties.Name.SESSION_CLIENT_ID, (Object)(client == null ? "unknown" : client));
            properties.put(LogProperties.Name.SESSION_SESSION, (Object)serverSession);
        }
    }

    public void clear() {
        this.session.remove();
    }

    @Override
    public Context getContext() {
        return this.getSessionObject().getContext();
    }

    @Override
    public Session optSessionObject() {
        ServerSession serverSession = this.session.get();
        if (serverSession == null && LogProperties.isEnabled()) {
            return (Session)LogProperties.getLogProperty((LogProperties.Name)LogProperties.Name.SESSION_SESSION);
        }
        return serverSession;
    }

    @Override
    public ServerSession getSessionObject() {
        ServerSession serverSession = this.session.get();
        if (serverSession == null && LogProperties.isEnabled()) {
            Session session = (Session)LogProperties.getLogProperty((LogProperties.Name)LogProperties.Name.SESSION_SESSION);
            try {
                return ServerSessionAdapter.valueOf(session);
            }
            catch (OXException e) {
                return null;
            }
        }
        return serverSession;
    }

    @Override
    public User getUser() {
        return this.getSessionObject().getUser();
    }
}

