/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource.internal;

import com.openexchange.mail.mime.QuotedInternetAddress;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;

public final class ResourceTools {
    private static final Pattern PATTERN_ALLOWED_CHARS = Pattern.compile("[\\S ]+");

    private ResourceTools() {
    }

    public static boolean validateResourceIdentifier(String identifier) {
        return PATTERN_ALLOWED_CHARS.matcher(identifier).matches();
    }

    public static boolean validateResourceEmail(String emailAddress) {
        try {
            new QuotedInternetAddress(emailAddress, true).validate();
            return true;
        }
        catch (AddressException e) {
            return false;
        }
    }
}

