/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.report.internal;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.login.LoginHandlerService;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.user.UserService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LastLoginRecorder
implements LoginHandlerService {
    private static volatile Integer maxClientCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int maxClientCount() {
        Integer tmp = maxClientCount;
        if (null != tmp) return tmp;
        Class<LastLoginRecorder> clazz = LastLoginRecorder.class;
        synchronized (LastLoginRecorder.class) {
            tmp = maxClientCount;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            maxClientCount = tmp = Integer.valueOf(null == service ? -1 : service.getIntProperty("com.openexchange.user.maxClientCount", -1));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    @Override
    public void handleLogin(LoginResult login) throws OXException {
        String client;
        LoginRequest request = login.getRequest();
        if (null != request.getClient()) {
            client = request.getClient();
        } else if (null != request.getInterface()) {
            client = request.getInterface().toString();
        } else {
            return;
        }
        LastLoginRecorder.updateLastLogin(client, login.getUser(), login.getContext());
    }

    static void updateLastLogin(String client, User origUser, Context context) throws OXException {
        HashMap<String, Set<String>> attributes;
        String key = "client:" + client;
        if (context.isReadOnly()) {
            return;
        }
        int maxClientCount = LastLoginRecorder.maxClientCount();
        if (maxClientCount > 0) {
            Map<String, Set<String>> origAttributes = origUser.getAttributes();
            int count = 0;
            for (String origKey : origAttributes.keySet()) {
                if (!origKey.startsWith("client:") || ++count <= maxClientCount) continue;
                throw UserExceptionCode.UPDATE_ATTRIBUTES_FAILED.create(context.getContextId(), origUser.getId());
            }
            attributes = new HashMap<String, Set<String>>(origAttributes);
        } else {
            attributes = new HashMap<String, Set<String>>(origUser.getAttributes());
        }
        attributes.put(key, new HashSet<String>(Arrays.asList(Long.toString(System.currentTimeMillis()))));
        UserImpl newUser = new UserImpl();
        newUser.setId(origUser.getId());
        newUser.setAttributes(attributes);
        UserService service = ServerServiceRegistry.getInstance().getService(UserService.class, true);
        service.updateUser(newUser, context);
    }

    @Override
    public void handleLogout(LoginResult logout) {
    }
}

