/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.quota.json;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.documentation.annotations.Module;
import com.openexchange.exception.OXException;
import com.openexchange.quota.json.actions.GetAction;
import com.openexchange.quota.json.actions.MailAction;
import com.openexchange.server.ServiceLookup;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Module(name="quota", description="The quota module allows accesssing information about the use and quota of the filestore/mailstorage.")
public class QuotaActionFactory
implements AJAXActionServiceFactory {
    private final Map<String, AJAXActionService> actions = new ConcurrentHashMap<String, AJAXActionService>(5);

    public QuotaActionFactory(ServiceLookup services) {
        GetAction getAction = new GetAction(services);
        this.actions.put("get", getAction);
        this.actions.put("filestore", getAction);
        this.actions.put("mail", new MailAction(services));
    }

    @Override
    public AJAXActionService createActionService(String action) throws OXException {
        return this.actions.get(action);
    }

    public Collection<? extends AJAXActionService> getSupportedServices() {
        return Collections.unmodifiableCollection(this.actions.values());
    }
}

