/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.utils.DefaultFolderNamesProvider;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountAction;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.sql.Connection;
import java.util.EnumSet;
import org.apache.commons.logging.Log;

public final class Tools {
    private static final int RADIX = 10;

    private Tools() {
    }

    public static final int getUnsignedInteger(String s) {
        int digit;
        if (s == null) {
            return -1;
        }
        int max = s.length();
        if (max <= 0) {
            return -1;
        }
        if (s.charAt(0) == '-') {
            return -1;
        }
        int result = 0;
        int i = 0;
        int limit = -2147483647;
        int multmin = -214748364;
        if (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                return -1;
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                return -1;
            }
            if (result < -214748364) {
                return -1;
            }
            if ((result *= 10) < -2147483647 + digit) {
                return -1;
            }
            result -= digit;
        }
        return -result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MailAccount checkFullNames(MailAccount account, MailAccountStorageService storageService, Session session) throws OXException {
        if (0 == account.getId()) {
            return account;
        }
        int contextId = session.getContextId();
        Connection rcon = Database.get(contextId, false);
        try {
            MailAccount mailAccount = Tools.checkFullNames(account, storageService, session, rcon);
            return mailAccount;
        }
        finally {
            Database.back(contextId, false, rcon);
        }
    }

    public static MailAccount checkFullNames(MailAccount account, MailAccountStorageService storageService, Session session, Connection con) throws OXException {
        int accountId = account.getId();
        if (0 == accountId) {
            return account;
        }
        ServerSession serverSession = ServerSessionAdapter.valueOf(session);
        MailAccountDescription mad = new MailAccountDescription();
        mad.setId(accountId);
        EnumSet<Attribute> attributes = EnumSet.noneOf(Attribute.class);
        String mailServerURL = account.generateMailServerURL();
        String prefix = null != mailServerURL && mailServerURL.startsWith("pop3") ? "" : null;
        StringBuilder tmp = null;
        MailAccount primaryAccount = null;
        int userId = serverSession.getUserId();
        int contextId = serverSession.getContextId();
        try {
            MailAccount[] accounts;
            String name;
            String fullName = account.getConfirmedHamFullname();
            if (null == fullName) {
                if (null == prefix) {
                    prefix = Tools.getPrefix(accountId, serverSession);
                }
                if (null == (name = account.getConfirmedHam())) {
                    primaryAccount = storageService.getDefaultMailAccount(userId, contextId);
                    name = Tools.getName(5, primaryAccount);
                }
                tmp = new StringBuilder(prefix);
                mad.setConfirmedHamFullname(tmp.append(name).toString());
                attributes.add(Attribute.CONFIRMED_HAM_FULLNAME_LITERAL);
            }
            if (null == (fullName = account.getConfirmedSpamFullname())) {
                if (null == prefix) {
                    prefix = Tools.getPrefix(accountId, serverSession);
                    tmp = new StringBuilder(prefix);
                } else if (null == tmp) {
                    tmp = new StringBuilder(prefix);
                } else {
                    tmp.setLength(prefix.length());
                }
                name = account.getConfirmedSpam();
                if (null == name) {
                    if (null == primaryAccount) {
                        primaryAccount = storageService.getDefaultMailAccount(userId, contextId);
                    }
                    name = Tools.getName(4, primaryAccount);
                }
                mad.setConfirmedSpamFullname(tmp.append(name).toString());
                attributes.add(Attribute.CONFIRMED_SPAM_FULLNAME_LITERAL);
            }
            if (null == (fullName = account.getDraftsFullname())) {
                if (null == prefix) {
                    prefix = Tools.getPrefix(accountId, serverSession);
                    tmp = new StringBuilder(prefix);
                } else if (null == tmp) {
                    tmp = new StringBuilder(prefix);
                } else {
                    tmp.setLength(prefix.length());
                }
                name = account.getDrafts();
                if (null == name) {
                    if (null == primaryAccount) {
                        primaryAccount = storageService.getDefaultMailAccount(userId, contextId);
                    }
                    name = Tools.getName(0, primaryAccount);
                }
                if ("Drafts".equals(name) && account.getMailServer().endsWith("yahoo.com")) {
                    name = "Draft";
                    mad.setDrafts(name);
                    attributes.add(Attribute.DRAFTS_LITERAL);
                }
                mad.setDraftsFullname(tmp.append(name).toString());
                attributes.add(Attribute.DRAFTS_FULLNAME_LITERAL);
            }
            if (null == (fullName = account.getSentFullname())) {
                if (null == prefix) {
                    prefix = Tools.getPrefix(accountId, serverSession);
                    tmp = new StringBuilder(prefix);
                } else if (null == tmp) {
                    tmp = new StringBuilder(prefix);
                } else {
                    tmp.setLength(prefix.length());
                }
                name = account.getSent();
                if (null == name) {
                    if (null == primaryAccount) {
                        primaryAccount = storageService.getDefaultMailAccount(userId, contextId);
                    }
                    name = Tools.getName(1, primaryAccount);
                }
                if ("Sent Items".equals(name) && account.getMailServer().endsWith("yahoo.com")) {
                    name = "Sent";
                    mad.setSent(name);
                    attributes.add(Attribute.SENT_LITERAL);
                }
                mad.setSentFullname(tmp.append(name).toString());
                attributes.add(Attribute.SENT_FULLNAME_LITERAL);
            }
            if (null == (fullName = account.getSpamFullname())) {
                if (null == prefix) {
                    prefix = Tools.getPrefix(accountId, serverSession);
                    tmp = new StringBuilder(prefix);
                } else if (null == tmp) {
                    tmp = new StringBuilder(prefix);
                } else {
                    tmp.setLength(prefix.length());
                }
                name = account.getSpam();
                if (null == name) {
                    if (null == primaryAccount) {
                        primaryAccount = storageService.getDefaultMailAccount(userId, contextId);
                    }
                    name = Tools.getName(2, primaryAccount);
                }
                if ("Spam".equals(name) && account.getMailServer().endsWith("yahoo.com")) {
                    name = "Bulk Mail";
                    mad.setDrafts(name);
                    attributes.add(Attribute.DRAFTS_LITERAL);
                }
                mad.setSpamFullname(tmp.append(name).toString());
                attributes.add(Attribute.SPAM_FULLNAME_LITERAL);
            }
            if (null == (fullName = account.getTrashFullname())) {
                if (null == prefix) {
                    prefix = Tools.getPrefix(accountId, serverSession);
                    tmp = new StringBuilder(prefix);
                } else if (null == tmp) {
                    tmp = new StringBuilder(prefix);
                } else {
                    tmp.setLength(prefix.length());
                }
                name = account.getTrash();
                if (null == name) {
                    if (null == primaryAccount) {
                        primaryAccount = storageService.getDefaultMailAccount(userId, contextId);
                    }
                    name = Tools.getName(3, primaryAccount);
                }
                mad.setTrashFullname(tmp.append(name).toString());
                attributes.add(Attribute.TRASH_FULLNAME_LITERAL);
            }
            if (attributes.isEmpty()) {
                return account;
            }
            if (null == con) {
                storageService.updateMailAccount(mad, attributes, userId, contextId, serverSession);
                return storageService.getMailAccount(accountId, userId, contextId);
            }
            storageService.updateMailAccount(mad, attributes, userId, contextId, serverSession, con, false);
            for (MailAccount macc : accounts = storageService.getUserMailAccounts(userId, contextId, con)) {
                if (macc.getId() != accountId) continue;
                return macc;
            }
            return null;
        }
        catch (OXException e) {
            StringBuilder sb = new StringBuilder("Checking default folder full names for account ");
            sb.append(account.getId()).append(" failed with user ").append(userId);
            sb.append(" in context ").append(contextId);
            com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(AbstractMailAccountAction.class)).warn((Object)sb.toString(), (Throwable)e);
            return account;
        }
    }

    private static String getName(int index, MailAccount primaryAccount) {
        String retval;
        switch (index) {
            case 0: {
                retval = primaryAccount.getDrafts();
                if (null != retval) break;
                retval = DefaultFolderNamesProvider.DEFAULT_PROVIDER.getDrafts();
                break;
            }
            case 1: {
                retval = primaryAccount.getSent();
                if (null != retval) break;
                retval = DefaultFolderNamesProvider.DEFAULT_PROVIDER.getSent();
                break;
            }
            case 2: {
                retval = primaryAccount.getSpam();
                if (null != retval) break;
                retval = DefaultFolderNamesProvider.DEFAULT_PROVIDER.getSpam();
                break;
            }
            case 3: {
                retval = primaryAccount.getTrash();
                if (null != retval) break;
                retval = DefaultFolderNamesProvider.DEFAULT_PROVIDER.getTrash();
                break;
            }
            case 4: {
                retval = primaryAccount.getConfirmedSpam();
                if (null != retval) break;
                retval = DefaultFolderNamesProvider.DEFAULT_PROVIDER.getConfirmedSpam();
                break;
            }
            case 5: {
                retval = primaryAccount.getConfirmedHam();
                if (null != retval) break;
                retval = DefaultFolderNamesProvider.DEFAULT_PROVIDER.getConfirmedHam();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown index value: " + index);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPrefix(int accountId, ServerSession session) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> access = null;
        try {
            access = MailAccess.getInstance(session, accountId);
            access.connect(false);
            String string = access.getFolderStorage().getDefaultFolderPrefix();
            return string;
        }
        finally {
            if (null != access) {
                access.close(true);
            }
        }
    }
}

