/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.transport.config;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.transport.config.ITransportProperties;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.mailaccount.MailAccount;
import java.util.Map;

public class MailAccountTransportProperties
implements ITransportProperties {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MailAccountTransportProperties.class));
    protected final Map<String, String> properties;

    public MailAccountTransportProperties(MailAccount mailAccount) {
        if (null == mailAccount) {
            throw new IllegalArgumentException("mail account is null.");
        }
        this.properties = mailAccount.getProperties();
    }

    @Override
    public int getReferencedPartLimit() {
        String referencedPartLimitStr = this.properties.get("com.openexchange.mail.transport.referencedPartLimit");
        if (null == referencedPartLimitStr) {
            return TransportProperties.getInstance().getReferencedPartLimit();
        }
        try {
            return Integer.parseInt(referencedPartLimitStr);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Referenced Part Limit: Invalid value.", (Throwable)e);
            return TransportProperties.getInstance().getReferencedPartLimit();
        }
    }
}

