/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.mime.RFC2231Tools;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.MimeUtility;
import org.apache.commons.logging.Log;

public final class ParameterList
implements Cloneable,
Serializable,
Comparable<ParameterList> {
    private static final long serialVersionUID = 1085330725813918879L;
    private static final transient Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ParameterList.class));
    private static final Pattern PATTERN_PARAM_LIST;
    private static final Pattern PATTERN_PARAM_CORRECT;
    private static final String CHARSET_UTF_8 = "utf-8";
    private Map<String, Parameter> parameters = new HashMap<String, Parameter>();
    private static final char[] SPECIALS;
    private static final Pattern PAT_BSLASH;
    private static final Pattern PAT_QUOTE;

    public ParameterList() {
    }

    public ParameterList(String parameterList) {
        this();
        this.parseParameterList(ParameterList.correctParamList(parameterList.trim()));
    }

    private static String correctParamList(String parameterList) {
        String toParse = parameterList;
        int len = toParse.length();
        if (len > 0 && ';' != toParse.charAt(0)) {
            toParse = new StringAllocator(len + 2).append("; ").append(toParse).toString();
        }
        return PATTERN_PARAM_CORRECT.matcher(toParse).replaceAll("$1$2\"$3\"$4");
    }

    @Override
    public int compareTo(ParameterList other) {
        if (this == other) {
            return 0;
        }
        if (this.parameters == null) {
            if (other.parameters != null) {
                return -1;
            }
            return 0;
        }
        if (other.parameters == null) {
            return 1;
        }
        return this.toString().compareToIgnoreCase(other.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameters == null ? 0 : this.toString().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterList other = (ParameterList)obj;
        return !(this.parameters == null ? other.parameters != null : !this.toString().equalsIgnoreCase(other.toString()));
    }

    public Object clone() {
        try {
            ParameterList clone = (ParameterList)super.clone();
            int size = this.parameters.size();
            clone.parameters = new HashMap<String, Parameter>(size);
            if (size > 0) {
                Iterator<Map.Entry<String, Parameter>> iter = this.parameters.entrySet().iterator();
                for (int i = 0; i < size; ++i) {
                    Map.Entry<String, Parameter> e = iter.next();
                    clone.parameters.put(e.getKey(), (Parameter)e.getValue().clone());
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone failed even though 'Cloneable' interface is implemented");
        }
    }

    private void parseParameterList(String parameterList) {
        try {
            Matcher m = PATTERN_PARAM_LIST.matcher(parameterList);
            while (m.find()) {
                this.parseParameter(m.group(1).toLowerCase(Locale.ENGLISH), m.group(2));
            }
        }
        catch (StackOverflowError regexFailed) {
            int pos = parameterList.indexOf(59);
            while (pos >= 0) {
                int delim = parameterList.indexOf(61, pos);
                if (delim < 0) {
                    int pos2 = parameterList.indexOf(59, pos + 1);
                    String name = pos2 < 0 ? parameterList.substring(pos + 1).trim() : parameterList.substring(pos + 1, pos2).trim();
                    this.parseParameter(name.toLowerCase(Locale.ENGLISH), "");
                    pos = pos2;
                    continue;
                }
                String name = parameterList.substring(pos + 1, delim).trim();
                String value = (pos = parameterList.indexOf(59, pos + 1)) < 0 ? parameterList.substring(delim + 1) : parameterList.substring(delim + 1, pos);
                this.parseParameter(name.toLowerCase(Locale.ENGLISH), value);
            }
        }
    }

    private void parseParameter(String name, String value) {
        String val = value == null ? "" : (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"' ? ParameterList.unescape(value.substring(1, value.length() - 1)) : value);
        int pos = name.indexOf(42);
        if (pos == -1) {
            this.parameters.put(name, new Parameter(name, MimeMessageUtility.decodeMultiEncodedHeader(val)));
        } else {
            Parameter p = null;
            String soleName = name.substring(0, pos);
            String procName = name;
            if (procName.charAt(procName.length() - 1) == '*') {
                procName = procName.substring(0, procName.length() - 1);
                pos = procName.indexOf(42);
                p = this.parameters.get(soleName);
                if (null == p || !p.rfc2231) {
                    String[] encInfos = RFC2231Tools.parseRFC2231Value(val);
                    if (null == encInfos) {
                        return;
                    }
                    val = RFC2231Tools.rfc2231Decode(encInfos[2], encInfos[0]);
                    p = new Parameter(soleName);
                    p.charset = encInfos[0];
                    p.language = encInfos[1];
                    this.parameters.put(soleName, p);
                } else {
                    val = RFC2231Tools.rfc2231Decode(val, p.charset);
                }
            } else {
                p = this.parameters.get(soleName);
                if (null == p) {
                    p = new Parameter(soleName);
                    this.parameters.put(soleName, p);
                }
            }
            if (pos == -1) {
                p.addContiguousValue(val);
            } else {
                int num = -1;
                try {
                    num = Integer.parseInt(procName.substring(pos + 1));
                }
                catch (NumberFormatException e) {
                    num = -1;
                }
                if (num != -1) {
                    p.setContiguousValue(num, val);
                }
            }
        }
    }

    public void setParameter(String name, String value) {
        if (null == name || ParameterList.containsSpecial(name)) {
            OXException me = MailExceptionCode.INVALID_PARAMETER.create(name);
            LOG.error((Object)me.getMessage(), (Throwable)me);
            return;
        }
        this.parameters.put(name.toLowerCase(Locale.ENGLISH), new Parameter(name, value));
    }

    public void addParameter(String name, String value) {
        if (null == name || ParameterList.containsSpecial(name)) {
            OXException me = MailExceptionCode.INVALID_PARAMETER.create(name);
            LOG.error((Object)me.getMessage(), (Throwable)me);
            return;
        }
        String key = name.toLowerCase(Locale.ENGLISH);
        Parameter p = this.parameters.get(key);
        if (null == p) {
            this.parameters.put(key, new Parameter(name, value));
            return;
        }
        if (!p.rfc2231) {
            p.rfc2231 = true;
        }
        p.addContiguousValue(value);
    }

    public String getParameter(String name) {
        if (null == name) {
            return null;
        }
        Parameter p = this.parameters.get(name.toLowerCase(Locale.ENGLISH));
        if (null == p) {
            return null;
        }
        return p.getValue();
    }

    public String removeParameter(String name) {
        if (null == name) {
            return null;
        }
        Parameter p = this.parameters.remove(name.toLowerCase(Locale.ENGLISH));
        if (null == p) {
            return null;
        }
        return p.getValue();
    }

    public boolean containsParameter(String name) {
        if (null == name) {
            return false;
        }
        Parameter p = this.parameters.get(name.toLowerCase(Locale.ENGLISH));
        return null != p;
    }

    public Iterator<String> getParameterNames() {
        return this.parameters.keySet().iterator();
    }

    public void appendRFC2045String(StringAllocator sb) {
        this.appendRFC2045String(sb, false);
    }

    public void appendRFC2045String(StringAllocator sb, boolean skipEmptyParam) {
        int size = this.parameters.size();
        ArrayList<String> names = new ArrayList<String>(size);
        names.addAll(this.parameters.keySet());
        Collections.sort(names);
        if (skipEmptyParam) {
            for (String name : names) {
                Parameter parameter = this.parameters.get(name);
                if (parameter.contiguousValues.isEmpty()) continue;
                parameter.appendRFC2045String(sb);
            }
        } else {
            for (String name : names) {
                this.parameters.get(name).appendRFC2045String(sb);
            }
        }
    }

    public String toString() {
        StringAllocator sb = new StringAllocator(64);
        int size = this.parameters.size();
        ArrayList<String> names = new ArrayList<String>(size);
        names.addAll(this.parameters.keySet());
        Collections.sort(names);
        for (String name : names) {
            this.parameters.get(name).appendRFC2045String(sb);
        }
        return sb.toString();
    }

    private static boolean containsSpecial(String str) {
        int length = str.length();
        boolean quote = false;
        for (int i = 0; i < length && !quote; quote |= Arrays.binarySearch(SPECIALS, str.charAt(i)) >= 0, ++i) {
        }
        return quote;
    }

    static String checkQuotation(String str) {
        if (ParameterList.containsSpecial(str)) {
            return new StringAllocator(2 + str.length()).append('\"').append(PAT_QUOTE.matcher(PAT_BSLASH.matcher(str).replaceAll("\\\\\\\\")).replaceAll("\\\\\\\"")).append('\"').toString();
        }
        return str;
    }

    private static String unescape(String escaped) {
        StringAllocator sb = new StringAllocator(escaped.length());
        int length = escaped.length();
        boolean ignore = false;
        for (int i = 0; i < length; ++i) {
            char c = escaped.charAt(i);
            if ('\\' == c) {
                if (ignore) {
                    ignore = false;
                    continue;
                }
                sb.append(c);
                ignore = true;
                continue;
            }
            sb.append(c);
            ignore = true;
        }
        return sb.toString();
    }

    static {
        String paramNameRegex = "([\\p{L}\\p{ASCII}&&[^=\"\\s;]]+)";
        String tokenRegex = "(?:[^\"][\\S&&[^\\s,;:\\\\\"/\\[\\]?()<>@]]*)";
        String quotedStringRegex = "(?:\"(?:(?:\\\\\\\")|[^\"])+?\")";
        PATTERN_PARAM_LIST = Pattern.compile("(?:\\s*;\\s*|\\s+)([\\p{L}\\p{ASCII}&&[^=\"\\s;]]+)(?: *= *((?:[^\"][\\S&&[^\\s,;:\\\\\"/\\[\\]?()<>@]]*)|(?:\"(?:(?:\\\\\\\")|[^\"])+?\")))?");
        PATTERN_PARAM_CORRECT = Pattern.compile("(?:\\s*;\\s*|\\s+)([\\p{L}\\p{ASCII}&&[^=\"\\s;]]+)( *= *)([^\" ][^; \t]*[ \t][^;]*)($|;)");
        SPECIALS = new char[]{'\t', '\n', '\r', ' ', '\"', '(', ')', ',', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']'};
        PAT_BSLASH = Pattern.compile("\\\\");
        PAT_QUOTE = Pattern.compile("\"");
    }

    private static final class Parameter
    implements Cloneable,
    Serializable,
    Comparable<Parameter> {
        private static final transient Log LOG1 = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Parameter.class));
        private static final long serialVersionUID = 7978948703870567515L;
        boolean rfc2231;
        final String name;
        ArrayList<String> contiguousValues;
        String charset;
        String language;
        String value;

        public Parameter(String name) {
            this.rfc2231 = true;
            this.name = name;
            this.contiguousValues = new ArrayList(2);
        }

        public Parameter(String name, String value) {
            this.rfc2231 = false;
            this.name = name;
            this.contiguousValues = new ArrayList(1);
            if (null != value && value.length() > 0) {
                this.contiguousValues.add(value);
            }
        }

        @Override
        public int compareTo(Parameter other) {
            if (this == other) {
                return 0;
            }
            if (this.name == null) {
                if (other.name != null) {
                    return -1;
                }
                return 0;
            }
            if (other.name == null) {
                return 1;
            }
            int nameComp = this.name.compareToIgnoreCase(other.name);
            if (nameComp != 0) {
                return nameComp;
            }
            return this.getValue().compareToIgnoreCase(other.getValue());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.charset == null ? 0 : this.charset.hashCode());
            result = 31 * result + (this.contiguousValues == null ? 0 : this.getValue().hashCode());
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.rfc2231 ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Parameter other = (Parameter)obj;
            if (this.charset == null ? other.charset != null : !this.charset.equalsIgnoreCase(other.charset)) {
                return false;
            }
            if (this.contiguousValues == null ? other.contiguousValues != null : !this.getValue().equalsIgnoreCase(other.getValue())) {
                return false;
            }
            if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.rfc2231 == other.rfc2231;
        }

        public Object clone() {
            try {
                Parameter clone = (Parameter)super.clone();
                int size = this.contiguousValues.size();
                clone.contiguousValues = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    clone.contiguousValues.add(this.contiguousValues.get(i));
                }
                clone.value = null;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                LOG1.error((Object)e.getMessage(), (Throwable)e);
                throw new RuntimeException("Clone failed even though 'Cloneable' interface is implemented");
            }
        }

        public String getCharset() {
            return this.charset;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public void addContiguousValue(String contiguousValue) {
            if (null != this.value) {
                this.value = null;
            }
            if (null != contiguousValue && contiguousValue.length() > 0) {
                this.contiguousValues.add(contiguousValue);
            }
        }

        public void setContiguousValue(int num, String contiguousValue) {
            if (null != this.value) {
                this.value = null;
            }
            if (null != contiguousValue && contiguousValue.length() > 0) {
                while (num >= this.contiguousValues.size()) {
                    this.contiguousValues.add("");
                }
                this.contiguousValues.set(num, contiguousValue);
            }
        }

        public String getValue() {
            if (null == this.value) {
                StringAllocator sb = new StringAllocator(64);
                int size = this.contiguousValues.size();
                for (int i = 0; i < size; ++i) {
                    sb.append(this.contiguousValues.get(i));
                }
                this.value = sb.toString();
            }
            return this.value;
        }

        public void appendRFC2045String(StringAllocator sb) {
            int size = this.contiguousValues.size();
            if (size == 0) {
                sb.append("; ").append(this.name);
                return;
            }
            if (this.rfc2231) {
                if (size == 1) {
                    sb.append("; ").append(this.name);
                    if (this.getNextValidPos(0, size) != -1) {
                        if (RFC2231Tools.isAscii(this.getValue())) {
                            sb.append('=').append(ParameterList.checkQuotation(this.getValue()));
                        } else {
                            sb.append("*=").append(ParameterList.checkQuotation(RFC2231Tools.rfc2231Encode(this.getValue(), ParameterList.CHARSET_UTF_8, null, true)));
                        }
                    }
                } else {
                    boolean needsEncoding = false;
                    for (int i = 0; i < size && !needsEncoding; needsEncoding |= !RFC2231Tools.isAscii(this.contiguousValues.get(i)), ++i) {
                    }
                    int startPos = this.getNextValidPos(0, size);
                    if (startPos == -1) {
                        sb.append("; ").append(this.name);
                        return;
                    }
                    int count = 1;
                    sb.append("; ").append(this.name).append('*').append(count++);
                    if (needsEncoding) {
                        sb.append("*=").append(ParameterList.checkQuotation(RFC2231Tools.rfc2231Encode(this.contiguousValues.get(startPos), ParameterList.CHARSET_UTF_8, null, true, true)));
                    } else {
                        sb.append('=').append(ParameterList.checkQuotation(this.contiguousValues.get(startPos)));
                    }
                    while ((startPos = this.getNextValidPos(startPos + 1, size)) != -1) {
                        sb.append("; ").append(this.name).append('*').append(count++);
                        String chunk = this.contiguousValues.get(startPos);
                        if (RFC2231Tools.isAscii(chunk)) {
                            sb.append('=').append(ParameterList.checkQuotation(chunk));
                            continue;
                        }
                        sb.append("*=").append(ParameterList.checkQuotation(RFC2231Tools.rfc2231Encode(chunk, ParameterList.CHARSET_UTF_8, null, false)));
                    }
                }
                return;
            }
            try {
                sb.append("; ").append(this.name).append('=').append(ParameterList.checkQuotation(MimeUtility.encodeText((String)this.getValue(), (String)ParameterList.CHARSET_UTF_8, (String)"Q")));
            }
            catch (UnsupportedEncodingException e) {
                LOG1.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        private int getNextValidPos(int fromPos, int size) {
            for (int i = fromPos; i < size; ++i) {
                String val = this.contiguousValues.get(i);
                if (val == null || val.length() <= 0) continue;
                return i;
            }
            return -1;
        }

        public String toUnicodeString() {
            int size = this.contiguousValues.size();
            if (size == 0) {
                return new StringAllocator(this.name.length() + 2).append("; ").append(this.name).toString();
            }
            if (this.rfc2231) {
                StringAllocator sb = new StringAllocator(64);
                if (size == 1) {
                    sb.append("; ").append(this.name);
                    if (this.getNextValidPos(0, size) != -1) {
                        if (RFC2231Tools.isAscii(this.getValue())) {
                            sb.append('=').append(ParameterList.checkQuotation(this.getValue()));
                        } else {
                            sb.append("*=").append(ParameterList.checkQuotation(RFC2231Tools.rfc2231Encode(this.getValue(), ParameterList.CHARSET_UTF_8, null, true)));
                        }
                    }
                } else {
                    boolean needsEncoding = false;
                    for (int i = 0; i < size && !needsEncoding; needsEncoding |= !RFC2231Tools.isAscii(this.contiguousValues.get(i)), ++i) {
                    }
                    int startPos = this.getNextValidPos(0, size);
                    if (startPos == -1) {
                        sb.append("; ").append(this.name);
                        return sb.toString();
                    }
                    int count = 1;
                    sb.append("; ").append(this.name).append('*').append(count++);
                    if (needsEncoding) {
                        sb.append("*=").append(ParameterList.checkQuotation(RFC2231Tools.rfc2231Encode(this.contiguousValues.get(0), ParameterList.CHARSET_UTF_8, null, true, true)));
                    } else {
                        sb.append('=').append(ParameterList.checkQuotation(this.contiguousValues.get(0)));
                    }
                    while ((startPos = this.getNextValidPos(startPos + 1, size)) != -1) {
                        sb.append("; ").append(this.name).append('*').append(count++);
                        String chunk = this.contiguousValues.get(startPos);
                        if (RFC2231Tools.isAscii(chunk)) {
                            sb.append('=').append(ParameterList.checkQuotation(chunk));
                            continue;
                        }
                        sb.append("*=").append(ParameterList.checkQuotation(RFC2231Tools.rfc2231Encode(chunk, ParameterList.CHARSET_UTF_8, null, false)));
                    }
                }
                return sb.toString();
            }
            try {
                return new StringAllocator(64).append("; ").append(this.name).append('=').append(ParameterList.checkQuotation(MimeUtility.encodeText((String)ParameterList.CHARSET_UTF_8, (String)"Q", (String)this.getValue()))).toString();
            }
            catch (UnsupportedEncodingException e) {
                LOG1.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }
}

