/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.parser;

import com.openexchange.configuration.ConfigurationException;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.json.parser.IAttachmentHandler;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractAttachmentHandler
implements IAttachmentHandler {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(AbstractAttachmentHandler.class));
    protected final List<MailPart> attachments = new ArrayList<MailPart>(4);
    protected final boolean doAction;
    protected final long uploadQuota;
    protected final long uploadQuotaPerFile;

    public AbstractAttachmentHandler(Session session) throws OXException {
        UserSettingMail usm = session instanceof ServerSession ? ((ServerSession)session).getUserSettingMail() : UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), session.getContextId());
        if (usm.getUploadQuota() >= 0L) {
            this.uploadQuota = usm.getUploadQuota();
        } else {
            long tmp;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Upload quota is less than zero. Using global server property \"MAX_UPLOAD_SIZE\" instead.");
            }
            try {
                tmp = ServerConfig.getInt(ServerConfig.Property.MAX_UPLOAD_SIZE);
            }
            catch (ConfigurationException e) {
                LOG.warn((Object)(e.getMessage() + " Using no upload restrictions as fallback."), (Throwable)((Object)e));
                tmp = 0L;
            }
            this.uploadQuota = tmp;
        }
        this.uploadQuotaPerFile = usm.getUploadQuotaPerFile();
        this.doAction = this.uploadQuotaPerFile > 0L || this.uploadQuota > 0L;
    }
}

