/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.server.ServiceLookup;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

@Action(method=RequestMethod.GET, name="zip_attachments", description="Get multiple mail attachments as a ZIP file.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="The folder identifier."), @Parameter(name="id", description="Object ID of the mail which contains the attachments."), @Parameter(name="attachment", description="A comma-separated list of IDs of the requested attachments")}, responseDescription="The raw byte data of the ZIP file.")
public final class GetMultipleAttachmentAction
extends AbstractMailAction {
    public GetMultipleAttachmentAction(ServiceLookup services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        AJAXRequestResult aJAXRequestResult;
        block12: {
            String folderPath = req.checkParameter("folder");
            String uid = req.checkParameter("id");
            String[] sequenceIds = req.checkStringArray("attachment");
            MailServletInterface mailInterface = this.getMailInterface(req);
            ManagedFile mf = null;
            try {
                mf = mailInterface.getMessageAttachments(folderPath, uid, sequenceIds);
                String subject = mailInterface.getMessage(folderPath, uid).getSubject();
                String fileName = new StringAllocator(subject).append(".zip").toString();
                ThresholdFileHolder fileHolder = new ThresholdFileHolder();
                InputStream zipInputStream = mf.getInputStream();
                try {
                    fileHolder.write(zipInputStream);
                }
                finally {
                    Streams.close((Closeable)zipInputStream);
                }
                req.getRequest().setFormat("file");
                fileHolder.setName(fileName);
                fileHolder.setContentType("application/zip");
                aJAXRequestResult = new AJAXRequestResult((Object)fileHolder, "file");
                if (null == mf) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (null != mf) {
                        mf.delete();
                        mf = null;
                    }
                    throw throwable;
                }
                catch (OXException e) {
                    IOException ioe;
                    if (e.getCause() instanceof IOException && "com.sun.mail.util.MessageRemovedIOException".equals((ioe = (IOException)e.getCause()).getClass().getName())) {
                        throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(ioe, new Object[0]);
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
                }
            }
            mf.delete();
            mf = null;
        }
        return aJAXRequestResult;
    }
}

