/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects;

import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.HeaderCollection;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import org.apache.commons.logging.Log;

public abstract class MailPart
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4688498122773765967L;
    public static final int NO_ENCLOSED_PARTS = -1;
    private static final transient Iterator<Map.Entry<String, String>> EMPTY_ITER = new Iterator<Map.Entry<String, String>>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Map.Entry<String, String> next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };
    private static final transient Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailPart.class));
    private ContentType contentType = new ContentType();
    private boolean b_contentType;
    private ContentDisposition contentDisposition;
    private boolean b_disposition;
    private String fileName;
    private boolean b_fileName;
    private HeaderCollection headers;
    private boolean b_headers;
    private long size = -1L;
    private boolean b_size;
    private String contentId;
    private boolean b_contentId;
    private String sequenceId;
    private boolean b_sequenceId;
    private MailPath msgref;
    private boolean b_msgref;

    protected MailPart() {
        this.contentType.setPrimaryType("text");
        this.contentType.setSubType("plain");
        this.contentType.setCharsetParameter("us-ascii");
        this.contentDisposition = new ContentDisposition();
    }

    public ContentType getContentType() {
        String ct;
        if (!this.b_contentType && (ct = this.getFirstHeader("Content-Type")) != null) {
            try {
                this.setContentType(new ContentType(ct));
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.contentType;
    }

    public boolean containsContentType() {
        return this.b_contentType || this.containsHeader("Content-Type");
    }

    public void removeContentType() {
        try {
            this.contentType = new ContentType("text/plain; charset=us-ascii");
            if (this.headers != null) {
                this.headers.setHeader("Content-Type", "text/plain; charset=us-ascii");
            }
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        this.b_contentType = false;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
        this.b_contentType = true;
    }

    public void setContentType(String contentType) throws OXException {
        this.contentType = new ContentType(contentType);
        this.b_contentType = true;
    }

    public ContentDisposition getContentDisposition() {
        String disp;
        if (!this.b_disposition && (disp = this.getFirstHeader("Content-Disposition")) != null) {
            try {
                this.setContentDisposition(new ContentDisposition(disp));
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.contentDisposition;
    }

    public boolean containsContentDisposition() {
        return this.b_disposition || this.containsHeader("Content-Disposition");
    }

    public void removeContentDisposition() {
        this.contentDisposition = null;
        this.removeHeader("Content-Disposition");
        this.b_disposition = false;
    }

    public void setContentDisposition(String disposition) throws OXException {
        this.contentDisposition = new ContentDisposition(disposition);
        this.b_disposition = true;
    }

    public void setContentDisposition(ContentDisposition disposition) {
        this.contentDisposition = disposition;
        this.b_disposition = true;
    }

    public String getFileName() {
        if (this.b_fileName) {
            return this.fileName;
        }
        String fn = this.contentDisposition.getFilenameParameter();
        if (fn == null) {
            fn = this.contentType.getNameParameter();
        }
        return fn;
    }

    public boolean containsFileName() {
        return this.b_fileName;
    }

    public void removeFileName() {
        this.fileName = null;
        this.b_fileName = false;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        if (null != this.fileName) {
            this.contentType.setNameParameter(fileName);
            this.contentDisposition.setFilenameParameter(fileName);
        }
        this.b_fileName = true;
    }

    public void addHeader(String name, String value) {
        if (null == value) {
            return;
        }
        if (null == this.headers) {
            this.headers = new HeaderCollection();
            this.b_headers = true;
        }
        this.headers.addHeader(name, value);
    }

    public void setHeader(String name, String value) {
        if (null == value) {
            return;
        }
        if (null == this.headers) {
            this.headers = new HeaderCollection();
            this.b_headers = true;
        }
        this.headers.setHeader(name, value);
    }

    public void addHeaders(HeaderCollection headers) {
        if (null == headers || headers.isEmpty()) {
            return;
        }
        if (null == this.headers) {
            this.headers = new HeaderCollection();
            this.b_headers = true;
        }
        this.headers.addHeaders(headers);
    }

    public boolean containsHeaders() {
        return this.b_headers;
    }

    public void removeHeaders() {
        this.headers = null;
        this.b_headers = false;
    }

    public int getHeadersSize() {
        if (null == this.headers) {
            return 0;
        }
        return this.headers.size();
    }

    public Iterator<Map.Entry<String, String>> getHeadersIterator() {
        if (null == this.headers) {
            return EMPTY_ITER;
        }
        return this.headers.getAllHeaders();
    }

    public boolean containsHeader(String name) {
        if (null == this.headers) {
            return false;
        }
        return this.headers.containsHeader(name);
    }

    public String[] getHeader(String name) {
        if (this.containsHeaders() && null != this.headers) {
            return this.headers.getHeader(name);
        }
        return null;
    }

    public String getFirstHeader(String name) {
        return this.getHeader(name, null);
    }

    public String getHeader(String name, String delimiter) {
        if (this.containsHeaders() && null != this.headers) {
            return this.headers.getHeader(name, delimiter);
        }
        return null;
    }

    public String getHeader(String name, char delimiter) {
        if (this.containsHeaders() && null != this.headers) {
            return this.headers.getHeader(name, delimiter);
        }
        return null;
    }

    public HeaderCollection getHeaders() {
        if (this.containsHeaders() && null != this.headers) {
            return this.headers.getReadOnlyCollection();
        }
        return HeaderCollection.EMPTY_COLLECTION;
    }

    public Iterator<Map.Entry<String, String>> getNonMatchingHeaders(String[] nonMatchingHeaders) {
        if (this.containsHeaders() && null != this.headers) {
            return this.headers.getNonMatchingHeaders(nonMatchingHeaders);
        }
        return EMPTY_ITER;
    }

    public Iterator<Map.Entry<String, String>> getMatchingHeaders(String[] matchingHeaders) {
        if (this.containsHeaders() && null != this.headers) {
            return this.headers.getMatchingHeaders(matchingHeaders);
        }
        return EMPTY_ITER;
    }

    public void removeHeader(String name) {
        if (this.containsHeaders() && null != this.headers) {
            this.headers.removeHeader(name);
        }
    }

    public boolean hasHeaders(String ... names) {
        boolean ret = true;
        for (int i = 0; ret && i < names.length; ++i) {
            ret = this.headers.containsHeader(names[i]);
        }
        return ret;
    }

    public long getSize() {
        return this.size;
    }

    public boolean containsSize() {
        return this.b_size;
    }

    public void removeSize() {
        this.size = -1L;
        this.b_size = false;
    }

    public void setSize(long size) {
        this.size = size;
        this.b_size = true;
    }

    public String getContentId() {
        String cid;
        if (!this.b_contentId && (cid = this.getFirstHeader("Content-ID")) != null) {
            this.setContentId(cid);
        }
        return this.contentId;
    }

    public boolean containsContentId() {
        return this.b_contentId || this.containsHeader("Content-ID");
    }

    public void removeContentId() {
        this.contentId = null;
        this.removeHeader("Content-ID");
        this.b_contentId = false;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
        this.b_contentId = true;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public boolean containsSequenceId() {
        return this.b_sequenceId;
    }

    public void removeSequenceId() {
        this.sequenceId = null;
        this.b_sequenceId = false;
    }

    public void setSequenceId(String sequenceId) {
        this.sequenceId = sequenceId;
        this.b_sequenceId = true;
    }

    public MailPath getMsgref() {
        if (this.b_msgref) {
            return this.msgref;
        }
        String xMsgref = this.getFirstHeader("X-OXMsgref");
        if (null != xMsgref) {
            this.removeHeader("X-OXMsgref");
            this.b_msgref = true;
            try {
                this.msgref = new MailPath(xMsgref);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                this.msgref = null;
            }
        }
        return this.msgref;
    }

    public boolean containsMsgref() {
        if (this.b_msgref) {
            return true;
        }
        return this.getHeader("X-OXMsgref") != null;
    }

    public void removeMsgref() {
        this.msgref = null;
        this.b_msgref = false;
        this.removeHeader("X-OXMsgref");
    }

    public void setMsgref(MailPath msgref) {
        this.msgref = msgref;
        this.b_msgref = true;
    }

    public Object clone() {
        try {
            MailPart clone = (MailPart)super.clone();
            if (this.contentType != null) {
                clone.contentType = new ContentType(this.contentType.toString());
            }
            if (null != this.headers) {
                clone.headers = new HeaderCollection(this.headers);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new InternalError(e.getMessage());
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new InternalError(e.getMessage());
        }
    }

    public boolean hasEnclosedParts() throws OXException {
        return this.getEnclosedCount() != -1;
    }

    public abstract Object getContent() throws OXException;

    public abstract DataHandler getDataHandler() throws OXException;

    public abstract InputStream getInputStream() throws OXException;

    public abstract int getEnclosedCount() throws OXException;

    public abstract MailPart getEnclosedMailPart(int var1) throws OXException;

    public abstract void loadContent() throws OXException;

    public void writeTo(OutputStream out) throws OXException {
        InputStream in = this.getInputStream();
        if (null == in) {
            throw MailExceptionCode.NO_CONTENT.create();
        }
        try {
            byte[] buf = new byte[8192];
            int count = -1;
            while ((count = in.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, count);
            }
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        finally {
            Streams.close((Closeable)in);
        }
    }

    public String getSource() throws OXException {
        return new String(this.getSourceBytes(), Charsets.ISO_8859_1);
    }

    public byte[] getSourceBytes() throws OXException {
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(4096);
        this.writeTo((OutputStream)out);
        return out.toByteArray();
    }

    public abstract void prepareForCaching();
}

