/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.cache;

import com.openexchange.concurrent.TimeoutConcurrentMap;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.cache.IMailAccessCache;
import com.openexchange.mail.cache.MailAccessTimeoutListener;
import com.openexchange.mail.cache.MailCacheConfiguration;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;

public final class SingletonMailAccessCache
implements IMailAccessCache {
    private static volatile SingletonMailAccessCache singleton;
    private TimeoutConcurrentMap<Key, MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage>> timeoutMap;
    private int defaultIdleSeconds;

    public static SingletonMailAccessCache newInstance() throws OXException {
        SingletonMailAccessCache singletonCache = new SingletonMailAccessCache();
        singletonCache.initCache();
        return singletonCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SingletonMailAccessCache getInstance() throws OXException {
        if (null != singleton) return singleton;
        Class<SingletonMailAccessCache> clazz = SingletonMailAccessCache.class;
        synchronized (SingletonMailAccessCache.class) {
            if (null != singleton) return singleton;
            singleton = new SingletonMailAccessCache();
            singleton.initCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseInstance() {
        if (null == singleton) return;
        Class<SingletonMailAccessCache> clazz = SingletonMailAccessCache.class;
        synchronized (SingletonMailAccessCache.class) {
            if (null == singleton) return;
            singleton.releaseCache();
            singleton = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private SingletonMailAccessCache() throws OXException {
        this.initCache();
    }

    public void initCache() throws OXException {
        if (!MailCacheConfiguration.getInstance().isStarted()) {
            throw MailExceptionCode.INITIALIZATION_PROBLEM.create();
        }
        if (this.timeoutMap != null) {
            return;
        }
        this.timeoutMap = new TimeoutConcurrentMap(MailProperties.getInstance().getMailAccessCacheShrinkerSeconds());
        this.timeoutMap.setDefaultTimeoutListener(new MailAccessTimeoutListener());
        this.defaultIdleSeconds = MailProperties.getInstance().getMailAccessCacheIdleSeconds();
    }

    @Override
    public void close() {
        this.releaseCache();
    }

    public void releaseCache() {
        if (this.timeoutMap == null) {
            return;
        }
        this.timeoutMap.timeoutAll();
        this.timeoutMap.dispose();
        this.timeoutMap = null;
        this.defaultIdleSeconds = 0;
    }

    @Override
    public int numberOfMailAccesses(Session session, int accountId) throws OXException {
        return null == this.timeoutMap.get(SingletonMailAccessCache.getUserKey(session.getUserId(), accountId, session.getContextId())) ? 0 : 1;
    }

    @Override
    public MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> removeMailAccess(Session session, int accountId) {
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = this.timeoutMap.remove(SingletonMailAccessCache.getUserKey(session.getUserId(), accountId, session.getContextId()));
        if (null == mailAccess) {
            return null;
        }
        mailAccess.setCached(false);
        return mailAccess;
    }

    @Override
    public boolean putMailAccess(Session session, int accountId, MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess) {
        int idleTime = mailAccess.getCacheIdleSeconds();
        if (idleTime <= 0) {
            idleTime = this.defaultIdleSeconds;
        }
        if (null == this.timeoutMap.putIfAbsent(SingletonMailAccessCache.getUserKey(session.getUserId(), accountId, session.getContextId()), mailAccess, idleTime)) {
            mailAccess.setCached(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsMailAccess(Session session, int accountId) {
        return this.timeoutMap.get(SingletonMailAccessCache.getUserKey(session.getUserId(), accountId, session.getContextId())) != null;
    }

    @Override
    public void clearUserEntries(Session session) throws OXException {
        MailAccount[] accounts;
        int user = session.getUserId();
        int cid = session.getContextId();
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        for (MailAccount mailAccount : accounts = storageService.getUserMailAccounts(user, cid)) {
            this.timeoutMap.timeout(SingletonMailAccessCache.getUserKey(user, mailAccount.getId(), cid));
        }
    }

    private static Key getUserKey(int user, int accountId, int cid) {
        return new Key(user, cid, accountId);
    }

    private static final class Key {
        private final int user;
        private final int cid;
        private final int accountId;
        private final int hash;

        public Key(int user, int cid, int accountId) {
            this.user = user;
            this.cid = cid;
            this.accountId = accountId;
            this.hash = this.hashCode0();
        }

        private int hashCode0() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.accountId;
            result = 31 * result + this.cid;
            result = 31 * result + this.user;
            return result;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.accountId != other.accountId) {
                return false;
            }
            if (this.cid != other.cid) {
                return false;
            }
            return this.user == other.user;
        }
    }
}

