/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.image;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.DefaultDispatcherPrefixService;
import com.openexchange.exception.OXException;
import com.openexchange.image.ImageGetAction;
import com.openexchange.server.ServiceLookup;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ImageActionFactory
implements AJAXActionServiceFactory {
    private final Map<String, AJAXActionService> actions = new ConcurrentHashMap<String, AJAXActionService>();
    public static final ConcurrentMap<String, String> regName2Alias = new ConcurrentHashMap<String, String>();
    public static final ConcurrentMap<String, String> alias2regName = new ConcurrentHashMap<String, String>();
    public static final String ALIAS_APPENDIX = "image";

    public static void addMapping(String registrationName, String alias) {
        regName2Alias.put(registrationName, alias);
        alias2regName.put(alias, registrationName);
    }

    public static String getRegistrationNameFor(String url) {
        if (null == url) {
            return null;
        }
        String s = url;
        String path = DefaultDispatcherPrefixService.getInstance().getPrefix() + ALIAS_APPENDIX;
        int pos = s.indexOf(path);
        if (pos >= 0) {
            s = s.substring(pos + path.length());
        }
        for (Map.Entry entry : alias2regName.entrySet()) {
            String alias = (String)entry.getKey();
            if (!s.startsWith(alias)) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    public ImageActionFactory(ServiceLookup services) {
        this.actions.put("GET", new ImageGetAction(services));
    }

    @Override
    public AJAXActionService createActionService(String action) throws OXException {
        return this.actions.get(action);
    }

    public Collection<? extends AJAXActionService> getSupportedServices() {
        return Collections.unmodifiableCollection(this.actions.values());
    }
}

