/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools;

import com.openexchange.i18n.tools.TemplateReplacement;
import com.openexchange.i18n.tools.TemplateToken;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public final class RenderMap
implements Cloneable {
    private EnumMap<TemplateToken, TemplateReplacement> map = new EnumMap(TemplateToken.class);

    public RenderMap() {
    }

    public RenderMap(TemplateReplacement ... replacements) {
        this();
        for (TemplateReplacement replacement : replacements) {
            this.put(replacement);
        }
    }

    public List<TemplateReplacement> getChanges() {
        ArrayList<TemplateReplacement> changes = new ArrayList<TemplateReplacement>(this.map.size() >> 1);
        for (TemplateReplacement templateReplacement : this.map.values()) {
            if (!templateReplacement.changed()) continue;
            changes.add(templateReplacement);
        }
        return changes;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public TemplateReplacement put(TemplateReplacement replacement) {
        return this.map.put(replacement.getToken(), replacement);
    }

    public TemplateReplacement get(TemplateToken token) {
        return this.map.get((Object)token);
    }

    public TemplateReplacement get(String tokenStr) {
        TemplateToken token = TemplateToken.getByString(tokenStr);
        if (token == null) {
            return null;
        }
        return this.map.get((Object)token);
    }

    public boolean contains(TemplateToken token) {
        return this.map.containsKey((Object)token);
    }

    public Iterator<TemplateToken> getKeys() {
        return this.map.keySet().iterator();
    }

    public Iterator<TemplateReplacement> getValues() {
        return this.map.values().iterator();
    }

    public TemplateReplacement remove(TemplateToken token) {
        return this.map.remove((Object)token);
    }

    public RenderMap applyChangedStatus(boolean changed) {
        Iterator<TemplateReplacement> iter = this.map.values().iterator();
        int size = this.map.size();
        for (int i = 0; i < size; ++i) {
            iter.next().setChanged(changed);
        }
        return this;
    }

    public RenderMap applyLocale(Locale locale) {
        Iterator<TemplateReplacement> iter = this.map.values().iterator();
        int size = this.map.size();
        for (int i = 0; i < size; ++i) {
            iter.next().setLocale(locale);
        }
        return this;
    }

    public RenderMap applyTimeZone(TimeZone timeZone) {
        Iterator<TemplateReplacement> iter = this.map.values().iterator();
        int size = this.map.size();
        for (int i = 0; i < size; ++i) {
            iter.next().setTimeZone(timeZone);
        }
        return this;
    }

    public Object clone() {
        try {
            RenderMap clone = (RenderMap)super.clone();
            clone.map = new EnumMap(TemplateToken.class);
            Iterator<TemplateReplacement> iter = this.map.values().iterator();
            int size = this.map.size();
            for (int i = 0; i < size; ++i) {
                clone.put(iter.next().getClone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public RenderMap merge(RenderMap other) {
        Iterator<TemplateReplacement> iter = this.map.values().iterator();
        int size = this.map.size();
        EnumMap<TemplateToken, TemplateReplacement> otherMap = other.map;
        for (int i = 0; i < size; ++i) {
            TemplateReplacement replacement = iter.next();
            replacement.merge(otherMap.get((Object)replacement.getToken()));
        }
        return this;
    }
}

