/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ContactsAddUseCountColumnUpdateTask
implements UpdateTask {
    private final String ADD_COLUMN = "ALTER TABLE prg_contacts ADD COLUMN useCount INT4 UNSIGNED DEFAULT 0";
    private final String ADD_COLUMN_DEL = "ALTER TABLE del_contacts ADD COLUMN useCount INT4 UNSIGNED";
    private final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ContactsAddUseCountColumnUpdateTask.class));

    @Override
    public int addedWithVersion() {
        return 50;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        PreparedStatement stmt;
        Connection con;
        block7: {
            con = null;
            stmt = null;
            try {
                con = Database.getNoTimeout(contextId, true);
                if (Tools.columnExists(con, "prg_contacts", "useCount")) {
                    this.LOG.info((Object)"Column 'useCount' already exists in table 'prg_contacts'.");
                    break block7;
                }
                stmt = con.prepareStatement("ALTER TABLE prg_contacts ADD COLUMN useCount INT4 UNSIGNED DEFAULT 0");
                stmt.executeUpdate();
                stmt.close();
                stmt = con.prepareStatement("ALTER TABLE del_contacts ADD COLUMN useCount INT4 UNSIGNED");
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(stmt);
                    if (con != null) {
                        Database.backNoTimeout(contextId, true, con);
                    }
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(stmt);
        if (con != null) {
            Database.backNoTimeout(contextId, true, con);
        }
    }
}

