/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ContactCollectOnIncomingAndOutgoingMailUpdateTask
implements UpdateTask {
    private static final String TABLE = "user_setting_server";
    private static final String COLUMN_TRANSPORT = "contactCollectOnMailTransport";
    private static final String COLUMN_ACCESS = "contactCollectOnMailAccess";
    private static final String COLUMN_DEFINITION_TRANSPORT = "contactCollectOnMailTransport BOOL DEFAULT TRUE";
    private static final String COLUMN_DEFINITION_ACCESS = "contactCollectOnMailAccess BOOL DEFAULT TRUE";
    private static final String ALTER_TABLE = "ALTER TABLE user_setting_server ADD (";

    @Override
    public int addedWithVersion() {
        return 92;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            String stmt;
            con.setAutoCommit(false);
            StringBuilder sb = new StringBuilder(ALTER_TABLE);
            if (!Tools.columnExists(con, TABLE, COLUMN_TRANSPORT)) {
                sb.append(COLUMN_DEFINITION_TRANSPORT);
                sb.append(", ");
            }
            if (!Tools.columnExists(con, TABLE, COLUMN_ACCESS)) {
                sb.append(COLUMN_DEFINITION_ACCESS);
                sb.append(", ");
            }
            if ((stmt = sb.toString()).equals(ALTER_TABLE)) {
                return;
            }
            stmt = stmt.substring(0, stmt.length() - 2);
            stmt = stmt + ")";
            PreparedStatement pstmt = con.prepareStatement(stmt);
            pstmt.execute();
            pstmt.close();
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }
}

