/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.ContactAddUIDFieldTask;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.TIntList;
import gnu.trove.list.linked.TIntLinkedList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

public final class ContactAddUIDValueTask
extends UpdateTaskAdapter {
    @Override
    public int getPriority() {
        int priority = UpdateTask.UpdateTaskPriority.HIGH.priority;
        return priority;
    }

    @Override
    public String[] getDependencies() {
        return new String[]{ContactAddUIDFieldTask.class.getName()};
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection con = dbService.getForUpdateTask(cid);
        try {
            con.setAutoCommit(false);
            this.addUid("prg_contacts", con);
            this.addUid("del_contacts", con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUid(final String tableName, final Connection con) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT intfield01, cid FROM " + tableName + " WHERE uid IS NULL OR uid = ''");
            rs = stmt.executeQuery();
            TIntObjectHashMap map = new TIntObjectHashMap(1024);
            while (rs.next()) {
                int cid = rs.getInt(2);
                TIntList ids = (TIntList)map.get(cid);
                if (null == ids) {
                    ids = new TIntLinkedList();
                    map.put(cid, (Object)ids);
                }
                ids.add(rs.getInt(1));
            }
            DBUtils.closeSQLStuff(rs, stmt);
            final AtomicReference exceptionReference = new AtomicReference();
            map.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntList>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean execute(final int cid, TIntList ids) {
                    PreparedStatement innerStmt = null;
                    try {
                        final PreparedStatement pStmt = innerStmt = con.prepareStatement("UPDATE " + tableName + " SET uid = ? WHERE cid = ? AND intfield01 = ?");
                        ids.forEach(new TIntProcedure(){

                            public boolean execute(int id) {
                                try {
                                    pStmt.setString(1, UUID.randomUUID().toString());
                                    pStmt.setInt(2, cid);
                                    pStmt.setInt(3, id);
                                    pStmt.addBatch();
                                    return true;
                                }
                                catch (SQLException e) {
                                    exceptionReference.set(e);
                                    return false;
                                }
                            }
                        });
                        SQLException sqlException = (SQLException)exceptionReference.get();
                        if (null != sqlException) {
                            throw sqlException;
                        }
                        innerStmt.executeBatch();
                        boolean bl = true;
                        DBUtils.closeSQLStuff(innerStmt);
                        return bl;
                    }
                    catch (SQLException e) {
                        exceptionReference.set(e);
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        DBUtils.closeSQLStuff(innerStmt);
                    }
                }
            });
            SQLException sqlException = (SQLException)exceptionReference.get();
            if (null != sqlException) {
                throw sqlException;
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }
}

