/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.osgi;

import com.openexchange.groupware.reminder.TargetService;
import com.openexchange.groupware.reminder.internal.TargetRegistry;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class TargetRegistryCustomizer
implements ServiceTrackerCustomizer<TargetService, TargetService> {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(TargetRegistryCustomizer.class));
    private final BundleContext context;

    public TargetRegistryCustomizer(BundleContext context) {
        this.context = context;
    }

    public TargetService addingService(ServiceReference<TargetService> reference) {
        TargetService targetService = (TargetService)this.context.getService(reference);
        int module = this.parseModule(reference);
        if (-1 == module) {
            LOG.error((Object)("Registration of service " + targetService.getClass().getName() + " is missing property defining the module."));
            this.context.ungetService(reference);
            return null;
        }
        TargetRegistry.getInstance().addService(module, targetService);
        return targetService;
    }

    public void modifiedService(ServiceReference<TargetService> reference, TargetService service) {
    }

    public void removedService(ServiceReference<TargetService> reference, TargetService service) {
        if (null == service) {
            return;
        }
        TargetRegistry.getInstance().removeService(this.parseModule(reference));
        this.context.ungetService(reference);
    }

    private int parseModule(ServiceReference<TargetService> reference) {
        Object obj = reference.getProperty("MODULE");
        int retval = obj instanceof Integer ? Autoboxing.i((Integer)((Integer)obj)) : -1;
        return retval;
    }
}

