/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.internal;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.reminder.ReminderExceptionCode;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.reminder.ReminderStorage;
import com.openexchange.groupware.reminder.internal.DeleteReminder;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.ArrayIterator;
import com.openexchange.tools.iterator.SearchIterator;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;

public class GetArisingReminder {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(GetArisingReminder.class));
    private static final ReminderStorage STORAGE = ReminderStorage.getInstance();
    private final Session session;
    private final Context ctx;
    private final User user;
    private final Date end;

    public GetArisingReminder(Session session, Context ctx, User user, Date end) {
        this.session = session;
        this.ctx = ctx;
        this.user = user;
        this.end = (Date)end.clone();
    }

    public SearchIterator<ReminderObject> loadWithIterator() throws OXException {
        Object[] reminders = STORAGE.selectReminder(this.ctx, this.user, this.end);
        reminders = this.removeAppointments((ReminderObject[])reminders);
        return new ArrayIterator(reminders);
    }

    public ReminderObject[] removeAppointments(ReminderObject[] reminders) throws OXException {
        AppointmentSqlFactoryService factoryService = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class, true);
        AppointmentSQLInterface appointmentSql = factoryService.createAppointmentSql(this.session);
        ArrayList<ReminderObject> retval = new ArrayList<ReminderObject>(reminders.length);
        Date now = new Date();
        for (ReminderObject reminder : reminders) {
            if (1 == reminder.getModule()) {
                CalendarDataObject appointment;
                try {
                    appointment = appointmentSql.getObjectById(reminder.getTargetId(), reminder.getFolder());
                }
                catch (OXException e) {
                    if (e.isGeneric(OXException.Generic.NOT_FOUND)) {
                        STORAGE.deleteReminder(this.ctx, reminder);
                        continue;
                    }
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (SQLException e) {
                    OXException re = ReminderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                    LOG.debug((Object)re.getMessage(), (Throwable)re);
                    continue;
                }
                if (appointment.containsUntil() && appointment.getUntil().after(now)) {
                    retval.add(reminder);
                    continue;
                }
                if (appointment.getEndDate().after(now)) {
                    retval.add(reminder);
                    continue;
                }
                try {
                    new DeleteReminder(this.ctx, reminder).perform();
                    continue;
                }
                catch (OXException e) {
                    if (ReminderExceptionCode.NOT_FOUND.equals(e)) continue;
                    throw e;
                }
            }
            retval.add(reminder);
        }
        return retval.toArray(new ReminderObject[retval.size()]);
    }
}

