/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder;

import com.openexchange.tools.TimeZoneUtils;
import java.text.DateFormat;
import java.util.Date;

public class ReminderObject
implements Cloneable {
    private Date lastModified;
    private int userId;
    private Date date;
    private int objectId;
    private int targetId;
    private int module;
    private String description;
    private int folder;
    private boolean isRecurrenceAppointment;
    private int recurrencePosition;
    private static final DateFormat format = DateFormat.getDateTimeInstance(1, 1);

    public void setUser(int userId) {
        this.userId = userId;
    }

    public int getUser() {
        return this.userId;
    }

    public void setRecurrenceAppointment(boolean isRecurrenceAppointment) {
        this.isRecurrenceAppointment = isRecurrenceAppointment;
    }

    public boolean isRecurrenceAppointment() {
        return this.isRecurrenceAppointment;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public void setTargetId(int targetId) {
        this.targetId = targetId;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public void setObjectId(int objectId) {
        this.objectId = objectId;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public void setModule(int module) {
        this.module = module;
    }

    public int getModule() {
        return this.module;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setFolder(int folder) {
        this.folder = folder;
    }

    public int getFolder() {
        return this.folder;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = new Date(lastModified.getTime());
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setRecurrencePosition(int recurrencePosition) {
        this.recurrencePosition = recurrencePosition;
    }

    public int getRecurrencePosition() {
        return this.recurrencePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Reminder: ");
        if (null == this.date) {
            sb.append("no date");
        } else {
            DateFormat dateFormat = format;
            synchronized (dateFormat) {
                sb.append(format.format(this.getDate()));
            }
        }
        return sb.toString();
    }

    public ReminderObject clone() {
        try {
            ReminderObject clone = (ReminderObject)super.clone();
            clone.lastModified = this.lastModified == null ? null : new Date(this.lastModified.getTime());
            clone.date = this.date == null ? null : new Date(this.date.getTime());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("CloneNotSupportedException although Cloneable.");
        }
    }

    static {
        format.setTimeZone(TimeZoneUtils.getTimeZone("UTC"));
    }
}

