/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum UserExceptionCode implements OXExceptionCode
{
    PROPERTY_MISSING("Cannot find property %s.", Category.CATEGORY_CONFIGURATION, 1),
    DN_PROBLEM("Cannot build distinguished name from %s.", Category.CATEGORY_ERROR, 2),
    CLASS_NOT_FOUND("Class %s can not be loaded.", Category.CATEGORY_CONFIGURATION, 3),
    INSTANTIATION_PROBLEM("Cannot instantiate class %s.", Category.CATEGORY_CONFIGURATION, 4),
    NO_CONNECTION("Cannot get database connection.", Category.CATEGORY_SERVICE_DOWN, 5),
    NOT_CLONEABLE("Cannot clone object %1$s.", Category.CATEGORY_ERROR, 6),
    SQL_ERROR("SQL problem: \"%s\".", Category.CATEGORY_ERROR, 7),
    HASHING("Hash algorithm %s could not be found.", Category.CATEGORY_ERROR, 8),
    UNSUPPORTED_ENCODING("Encoding %s cannot be used.", Category.CATEGORY_ERROR, 9),
    USER_NOT_FOUND("Cannot find user with identifier %1$s in context %2$d.", Category.CATEGORY_ERROR, 10),
    USER_CONFLICT("Two users with same identifier %1$s in context %2$d found.", Category.CATEGORY_ERROR, 11),
    CACHE_PROBLEM("Problem putting/removing an object into/from the cache.", Category.CATEGORY_ERROR, 12),
    PERMISSION("No permission to modify resources in context %1$s", Category.CATEGORY_PERMISSION_DENIED, 13),
    MISSING_PASSWORD_MECH("Missing or unknown password mechanism %1$s", Category.CATEGORY_ERROR, 14),
    INVALID_PASSWORD("New password contains invalid characters", Category.CATEGORY_USER_INPUT, 15),
    ERASED_ATTRIBUTES("Attributes of user %1$d in context %2$d have been erased.", Category.CATEGORY_WARNING, 16),
    LOAD_FAILED("Loading one or more users failed.", Category.CATEGORY_ERROR, 17),
    ALIASES_MISSING("Alias entries are missing for user %1$d in context %2$d.", Category.CATEGORY_CONFIGURATION, 18),
    UPDATE_ATTRIBUTES_FAILED("Updating attributes failed in context %1$d for user %2$d.", Category.CATEGORY_ERROR, 19),
    INVALID_MIN_LENGTH("Invalid password length. The password must have a minimum length of %1$d.", Category.CATEGORY_USER_INPUT, 20),
    INVALID_MAX_LENGTH("Invalid password length. The password must have a maximum length of %1$d.", Category.CATEGORY_USER_INPUT, 21),
    MISSING_PARAMETER("The parameter %s for this user is missing.", Category.CATEGORY_USER_INPUT, 22),
    INVALID_LOCALE("%s is not a valid locale.", Category.CATEGORY_USER_INPUT, 23),
    INVALID_TIMEZONE("%s is not a valid timezone.", Category.CATEGORY_USER_INPUT, 24);

    private static final String PREFIX = "USR";
    private final String message;
    private final Category category;
    private final int detailNumber;

    private UserExceptionCode(String message, Category category, int detailNumber) {
        this.message = message;
        this.category = category;
        this.detailNumber = detailNumber;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPrefix() {
        return PREFIX;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

