/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport.importers;

import com.openexchange.data.conversion.ical.ConversionError;
import com.openexchange.data.conversion.ical.ConversionWarning;
import com.openexchange.data.conversion.ical.FreeBusyInformation;
import com.openexchange.data.conversion.ical.ICalParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;

public class ExtraneousSeriesMasterRecoveryParser
implements ICalParser {
    private final ICalParser delegate;
    private final ServerServiceRegistry registry;

    public ExtraneousSeriesMasterRecoveryParser(ICalParser delegate, ServerServiceRegistry registry) {
        this.delegate = delegate;
        this.registry = registry;
    }

    @Override
    public List<CalendarDataObject> parseAppointments(InputStream ical2, TimeZone defaultTZ, Context ctx, List<ConversionError> errors, List<ConversionWarning> warnings) throws ConversionError {
        return this.splitIfNeeded(this.delegate.parseAppointments(ical2, defaultTZ, ctx, errors, warnings));
    }

    @Override
    public List<CalendarDataObject> parseAppointments(String icalText, TimeZone defaultTZ, Context ctx, List<ConversionError> errors, List<ConversionWarning> warnings) throws ConversionError {
        return this.splitIfNeeded(this.delegate.parseAppointments(icalText, defaultTZ, ctx, errors, warnings));
    }

    private List<CalendarDataObject> splitIfNeeded(List<CalendarDataObject> appointments) throws ConversionError {
        CalendarCollectionService tools = this.registry.getService(CalendarCollectionService.class);
        int index = 0;
        LinkedList<CalendarDataObject> copy = new LinkedList<CalendarDataObject>(appointments);
        for (CalendarDataObject appointment : appointments) {
            try {
                if (appointment.isSequence() && !tools.isOccurrenceDate(appointment.getStartDate().getTime(), -1L, appointment, new long[0])) {
                    CalendarDataObject clone = appointment.clone();
                    tools.removeRecurringType(appointment);
                    copy.add(clone);
                }
            }
            catch (OXException e) {
                throw new ConversionError(index, e);
            }
            ++index;
        }
        return copy;
    }

    @Override
    public List<Task> parseTasks(InputStream ical2, TimeZone defaultTZ, Context context, List<ConversionError> errors, List<ConversionWarning> warnings) throws ConversionError {
        return this.delegate.parseTasks(ical2, defaultTZ, context, errors, warnings);
    }

    @Override
    public List<Task> parseTasks(String icalText, TimeZone defaultTZ, Context context, List<ConversionError> errors, List<ConversionWarning> warnings) throws ConversionError {
        return this.delegate.parseTasks(icalText, defaultTZ, context, errors, warnings);
    }

    @Override
    public String parseProperty(String propertyName, InputStream ical2) {
        return this.delegate.parseProperty(propertyName, ical2);
    }

    @Override
    public List<FreeBusyInformation> parseFreeBusy(String icalText, TimeZone defaultTZ, Context ctx, List<ConversionError> errors, List<ConversionWarning> warnings) throws ConversionError {
        return this.delegate.parseFreeBusy(icalText, defaultTZ, ctx, errors, warnings);
    }

    @Override
    public List<FreeBusyInformation> parseFreeBusy(InputStream ical2, TimeZone defaultTZ, Context ctx, List<ConversionError> errors, List<ConversionWarning> warnings) throws ConversionError {
        return this.delegate.parseFreeBusy(ical2, defaultTZ, ctx, errors, warnings);
    }

    @Override
    public void setLimit(int limit) {
        this.delegate.setLimit(limit);
    }
}

