/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.sql.SearchStrings;

public class Search {
    private Search() {
    }

    public static void checkPatternLength(ContactSearchObject searchData) throws OXException {
        int minimumSearchCharacters = Search.getMinimumSearchCharacters();
        if (0 == minimumSearchCharacters) {
            return;
        }
        for (String pattern : new String[]{searchData.getPattern(), searchData.getDisplayName(), searchData.getEmail1(), searchData.getEmail2(), searchData.getEmail3(), searchData.getGivenName(), searchData.getSurname()}) {
            Search.checkPatternLength(minimumSearchCharacters, pattern);
        }
    }

    private static int getMinimumSearchCharacters() throws OXException {
        return ServerConfig.getInt(ServerConfig.Property.MINIMUM_SEARCH_CHARACTERS);
    }

    public static void checkPatternLength(String pattern) throws OXException {
        int minimumSearchCharacters = Search.getMinimumSearchCharacters();
        if (0 == minimumSearchCharacters) {
            return;
        }
        Search.checkPatternLength(minimumSearchCharacters, pattern);
    }

    private static void checkPatternLength(int minimumSearchCharacters, String pattern) throws OXException {
        if (null != pattern && SearchStrings.lengthWithoutWildcards(pattern) < minimumSearchCharacters) {
            throw ContactExceptionCodes.TOO_FEW_SEARCH_CHARS.create(Autoboxing.I((int)minimumSearchCharacters));
        }
    }
}

