/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.update;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.server.services.ServerServiceRegistry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class UpdateFolderIdInReminder
implements UpdateTask {
    private static final String DELETE_ZERO_REMINDERS = "DELETE from reminder WHERE module = 1 AND folder < 1";
    private static final String FIND_REMINDERS = "SELECT target_id, cid, userid, folder from reminder WHERE module = ?";
    private static final String FIND_CURRENT_USER_FOLDER = "SELECT pfid from prg_dates_members WHERE cid = ? AND member_uid = ? AND object_id = ?";
    private static final String UPDATE_REMINDER = "UPDATE reminder SET folder = ? WHERE target_id = ? AND cid = ? AND userid = ? and module = ?";
    private static final String DELETE_REMINDER = "DELETE FROM reminder WHERE cid = ? AND target_id = ? AND userid = ? AND module = ?";
    private static final String CHECK_MAIN_OBJECT = "SELECT intfield01 FROM prg_dates WHERE cid = ? AND intfield01 = ?";
    private static final String DELETE_ENTRIES_MEMBERS = "DELETE FROM prg_dates_members WHERE cid = ? AND object_id = ?";
    private static final String DELETE_ENTRIES_RIGTHS = "DELETE FROM prg_date_rights WHERE cid = ? AND object_id = ?";
    private static final String FIND_WITHOUT_REFERENCE = "SELECT reminder.object_id, reminder.cid, reminder.userid, reminder.folder FROM reminder LEFT JOIN prg_dates ON reminder.cid = prg_dates.cid AND reminder.target_id = prg_dates.intfield01 where reminder.module = 1 AND intfield01 is NULL";

    @Override
    public int addedWithVersion() {
        return 10;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection writecon = null;
        Statement stmt = null;
        PreparedStatement pst = null;
        PreparedStatement pst2 = null;
        PreparedStatement pst3 = null;
        PreparedStatement pst4 = null;
        PreparedStatement pst5 = null;
        PreparedStatement pst6 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        ResultSet rs4 = null;
        CalendarCollectionService collection = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
        try {
            int a;
            ReminderUpdate ru;
            int fid;
            int uid;
            int cid;
            int oid;
            writecon = Database.get(contextId, true);
            try {
                stmt = writecon.createStatement();
            }
            catch (SQLException ex) {
                throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(ex, new Object[0]);
            }
            if (stmt != null) {
                try {
                    stmt.executeUpdate(DELETE_ZERO_REMINDERS);
                }
                catch (SQLException ex) {
                    throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(ex, new Object[0]);
                }
            }
            ArrayList<ReminderUpdate> update = new ArrayList<ReminderUpdate>(16);
            ArrayList<ReminderUpdate> delete = new ArrayList<ReminderUpdate>(16);
            ArrayList<ReminderUpdate> check = new ArrayList<ReminderUpdate>(16);
            try {
                pst = writecon.prepareStatement(FIND_REMINDERS, 1005, 1007);
                pst2 = writecon.prepareStatement(FIND_CURRENT_USER_FOLDER, 1005, 1007);
                pst.setInt(1, 1);
                rs = pst.executeQuery();
                while (rs.next()) {
                    oid = rs.getInt(1);
                    cid = rs.getInt(2);
                    uid = rs.getInt(3);
                    fid = rs.getInt(4);
                    pst2.setInt(1, cid);
                    pst2.setInt(2, uid);
                    pst2.setInt(3, oid);
                    ru = new ReminderUpdate();
                    ru.setOID(oid);
                    ru.setCID(cid);
                    ru.setUID(uid);
                    ru.setFID(fid);
                    rs2 = pst2.executeQuery();
                    if (rs2.next()) {
                        int pfid = rs2.getInt(1);
                        if (pfid != fid) {
                            update.add(ru);
                            continue;
                        }
                        check.add(ru);
                        continue;
                    }
                    delete.add(ru);
                }
            }
            catch (SQLException ex) {
                throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(ex, new Object[0]);
            }
            try {
                pst6 = writecon.prepareStatement(FIND_WITHOUT_REFERENCE, 1005, 1007);
                rs4 = pst6.executeQuery();
                while (rs4.next()) {
                    oid = rs4.getInt(1);
                    cid = rs4.getInt(2);
                    uid = rs4.getInt(3);
                    fid = rs4.getInt(4);
                    ru = new ReminderUpdate();
                    ru.setOID(oid);
                    if (!rs4.next()) continue;
                    delete.add(ru);
                }
            }
            catch (SQLException ex) {
                throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(ex, new Object[0]);
            }
            try {
                if (update.size() > 0) {
                    pst3 = writecon.prepareStatement(UPDATE_REMINDER);
                    for (a = 0; a < update.size(); ++a) {
                        ReminderUpdate ru2 = (ReminderUpdate)update.get(a);
                        pst3.setInt(1, ru2.getFID());
                        pst3.setInt(2, ru2.getOID());
                        pst3.setInt(3, ru2.getCID());
                        pst3.setInt(4, ru2.getUID());
                        pst3.setInt(5, 1);
                        pst3.addBatch();
                    }
                    pst3.executeBatch();
                }
            }
            catch (SQLException ex) {
                throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(ex, new Object[0]);
            }
            try {
                if (delete.size() > 0) {
                    pst4 = writecon.prepareStatement(DELETE_REMINDER);
                    for (a = 0; a < delete.size(); ++a) {
                        ReminderUpdate ru3 = (ReminderUpdate)delete.get(a);
                        pst4.setInt(1, ru3.getCID());
                        pst4.setInt(2, ru3.getOID());
                        pst4.setInt(3, ru3.getUID());
                        pst4.setInt(4, 1);
                        pst4.addBatch();
                    }
                    pst4.executeBatch();
                }
            }
            catch (SQLException ex) {
                throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(ex, new Object[0]);
            }
            try {
                if (update.size() > 0 || delete.size() > 0 || check.size() > 0) {
                    pst5 = writecon.prepareStatement(CHECK_MAIN_OBJECT, 1005, 1007);
                    if (update.size() > 0) {
                        for (a = 0; a < update.size(); ++a) {
                            ReminderUpdate ru4 = (ReminderUpdate)update.get(a);
                            pst5.setInt(1, ru4.getCID());
                            pst5.setInt(2, ru4.getOID());
                            rs3 = pst5.executeQuery();
                            if (rs3.next()) continue;
                            PreparedStatement members = writecon.prepareStatement(DELETE_ENTRIES_MEMBERS);
                            members.setInt(1, ru4.getCID());
                            members.setInt(2, ru4.getOID());
                            members.executeUpdate();
                            collection.closePreparedStatement(members);
                            PreparedStatement rights = writecon.prepareStatement(DELETE_ENTRIES_RIGTHS);
                            rights.setInt(1, ru4.getCID());
                            rights.setInt(2, ru4.getOID());
                            rights.executeUpdate();
                            collection.closePreparedStatement(rights);
                        }
                    }
                    if (delete.size() > 0) {
                        for (a = 0; a < delete.size(); ++a) {
                            ReminderUpdate ru5 = (ReminderUpdate)delete.get(a);
                            pst5.setInt(1, ru5.getCID());
                            pst5.setInt(2, ru5.getOID());
                            rs3 = pst5.executeQuery();
                            if (rs3.next()) continue;
                            PreparedStatement members = writecon.prepareStatement(DELETE_ENTRIES_MEMBERS);
                            members.setInt(1, ru5.getCID());
                            members.setInt(2, ru5.getOID());
                            members.executeUpdate();
                            collection.closePreparedStatement(members);
                            PreparedStatement rights = writecon.prepareStatement(DELETE_ENTRIES_RIGTHS);
                            rights.setInt(1, ru5.getCID());
                            rights.setInt(2, ru5.getOID());
                            rights.executeUpdate();
                            collection.closePreparedStatement(rights);
                        }
                    }
                    if (check.size() > 0) {
                        for (a = 0; a < check.size(); ++a) {
                            ReminderUpdate ru6 = (ReminderUpdate)check.get(a);
                            pst5.setInt(1, ru6.getCID());
                            pst5.setInt(2, ru6.getOID());
                            rs3 = pst5.executeQuery();
                            if (rs3.next()) continue;
                            PreparedStatement members = writecon.prepareStatement(DELETE_ENTRIES_MEMBERS);
                            members.setInt(1, ru6.getCID());
                            members.setInt(2, ru6.getOID());
                            members.executeUpdate();
                            collection.closePreparedStatement(members);
                            PreparedStatement rights = writecon.prepareStatement(DELETE_ENTRIES_RIGTHS);
                            rights.setInt(1, ru6.getCID());
                            rights.setInt(2, ru6.getOID());
                            rights.executeUpdate();
                            collection.closePreparedStatement(rights);
                        }
                    }
                }
            }
            catch (SQLException ex) {
                throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(ex, new Object[0]);
            }
            collection.closeResultSet(rs);
            collection.closeResultSet(rs2);
            collection.closeResultSet(rs3);
            collection.closeResultSet(rs4);
            collection.closePreparedStatement(pst);
            collection.closePreparedStatement(pst2);
            collection.closePreparedStatement(pst3);
            collection.closePreparedStatement(pst4);
            collection.closePreparedStatement(pst5);
            collection.closePreparedStatement(pst6);
            collection.closeStatement(stmt);
            if (writecon == null) return;
        }
        catch (Throwable throwable) {
            collection.closeResultSet(rs);
            collection.closeResultSet(rs2);
            collection.closeResultSet(rs3);
            collection.closeResultSet(rs4);
            collection.closePreparedStatement(pst);
            collection.closePreparedStatement(pst2);
            collection.closePreparedStatement(pst3);
            collection.closePreparedStatement(pst4);
            collection.closePreparedStatement(pst5);
            collection.closePreparedStatement(pst6);
            collection.closeStatement(stmt);
            if (writecon == null) throw throwable;
            Database.back(contextId, true, writecon);
            throw throwable;
        }
        Database.back(contextId, true, writecon);
    }

    private static class ReminderUpdate {
        private int oid;
        private int uid;
        private int fid;
        private int cid;

        private ReminderUpdate() {
        }

        private void setOID(int oid) {
            this.oid = oid;
        }

        private int getOID() {
            return this.oid;
        }

        private void setUID(int uid) {
            this.uid = uid;
        }

        private int getUID() {
            return this.uid;
        }

        private void setCID(int cid) {
            this.cid = cid;
        }

        private int getCID() {
            return this.cid;
        }

        private void setFID(int fid) {
            this.fid = fid;
        }

        private int getFID() {
            return this.fid;
        }
    }
}

