/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.osgi;

import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.internal.FolderStorageRegistry;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class FolderStorageTracker
implements ServiceTrackerCustomizer<FolderStorage, FolderStorage> {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(FolderStorageTracker.class));
    private final BundleContext context;

    public FolderStorageTracker(BundleContext context) {
        this.context = context;
    }

    public FolderStorage addingService(ServiceReference<FolderStorage> reference) {
        FolderStorage addedService = (FolderStorage)this.context.getService(reference);
        Object obj = reference.getProperty("tree");
        if (null == obj) {
            LOG.error((Object)new StringBuilder(32).append("Missing tree identifier property \"tree\" for ").append(addedService.getClass().getName()).toString());
            this.context.ungetService(reference);
            return null;
        }
        String treeId = obj.toString();
        if (FolderStorageRegistry.getInstance().addFolderStorage(treeId, addedService)) {
            return addedService;
        }
        LOG.error((Object)new StringBuilder(32).append("Failed registration to tree identifier \"").append(treeId).append("\" for ").append(addedService.getClass().getName()).toString());
        this.context.ungetService(reference);
        return null;
    }

    public void modifiedService(ServiceReference<FolderStorage> reference, FolderStorage service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<FolderStorage> reference, FolderStorage service) {
        if (null != service) {
            try {
                Object obj = reference.getProperty("tree");
                if (null == obj) {
                    LOG.error((Object)new StringBuilder(32).append("Missing tree identifier property \"tree\" for ").append(service.getClass().getName()).toString());
                    return;
                }
                String treeId = obj.toString();
                FolderStorageRegistry.getInstance().removeFolderStorage(treeId, service);
            }
            finally {
                this.context.ungetService(reference);
            }
        }
    }
}

