/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.messaging;

import com.openexchange.folderstorage.SortableId;
import com.openexchange.java.StringAllocator;

public final class MessagingId
implements SortableId {
    private final String fullname;
    private final int ordinal;
    private final String name;

    public MessagingId(String fullname, int ordinal, String name) {
        this.fullname = fullname;
        this.ordinal = ordinal;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.fullname;
    }

    @Override
    public SortableId.Priority getPriority() {
        return SortableId.Priority.NORMAL;
    }

    @Override
    public int compareTo(SortableId o) {
        int anotherPrio;
        if (o instanceof MessagingId) {
            int thisVal = this.ordinal;
            int anotherVal = ((MessagingId)o).ordinal;
            return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
        int thisPrio = this.getPriority().ordinal();
        return thisPrio < (anotherPrio = o.getPriority().ordinal()) ? 1 : (thisPrio == anotherPrio ? 0 : -1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.ordinal;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessagingId)) {
            return false;
        }
        MessagingId other = (MessagingId)obj;
        return this.ordinal == other.ordinal;
    }

    public String toString() {
        return new StringAllocator(32).append("{folderId=").append(this.fullname).append(", ordinal=").append(this.ordinal).append('}').toString();
    }
}

