/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database.getfolder;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.database.DatabaseFolder;
import com.openexchange.folderstorage.database.FolderIdNamePair;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;

public final class SharedPrefixFolder {
    private SharedPrefixFolder() {
    }

    public static boolean existsSharedPrefixFolder(String folderIdentifier, User user, UserConfiguration userConfiguration, Context ctx, Connection con) throws OXException {
        int sharedOwner;
        try {
            sharedOwner = Integer.parseInt(folderIdentifier.substring(2));
        }
        catch (NumberFormatException exc) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(exc, exc.getMessage());
        }
        return OXFolderIteratorSQL.hasVisibleSharedFolders(user.getId(), user.getGroups(), userConfiguration.getAccessibleModules(), sharedOwner, ctx, null, con);
    }

    public static DatabaseFolder getSharedPrefixFolder(String folderIdentifier, User user, Context ctx) throws OXException {
        String creatorDisplayName;
        int sharedOwner;
        try {
            sharedOwner = Integer.parseInt(folderIdentifier.substring(2));
        }
        catch (NumberFormatException exc) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(exc, exc.getMessage());
        }
        try {
            creatorDisplayName = UserStorage.getInstance().getUser(sharedOwner, ctx).getDisplayName();
        }
        catch (OXException e) {
            if (sharedOwner != 0) {
                throw e;
            }
            creatorDisplayName = StringHelper.valueOf(user.getLocale()).getString("All users");
        }
        FolderObject virtualOwnerFolder = FolderObject.createVirtualSharedFolderObject(sharedOwner, creatorDisplayName);
        DatabaseFolder retval = new DatabaseFolder(virtualOwnerFolder, false);
        retval.setID(folderIdentifier);
        retval.setParentID(String.valueOf(3));
        retval.setGlobal(false);
        retval.setSubfolderIDs(null);
        retval.setSubscribedSubfolders(true);
        return retval;
    }

    public static int[] getSharedPrefixFolderSubfoldersAsInt(String folderIdentifier, User user, UserConfiguration userConfiguration, Context ctx, Connection con) throws OXException {
        int sharedOwner;
        try {
            sharedOwner = Integer.parseInt(folderIdentifier.substring(2));
        }
        catch (NumberFormatException exc) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(exc, exc.getMessage());
        }
        Queue<FolderObject> q = ((FolderObjectIterator)OXFolderIteratorSQL.getVisibleSharedFolders(user.getId(), user.getGroups(), userConfiguration.getAccessibleModules(), sharedOwner, ctx, null, con)).asQueue();
        if (q.isEmpty()) {
            return new int[0];
        }
        int size = q.size();
        TIntObjectMap<FolderObject> set = SharedPrefixFolder.getFirstLevelSharedFolders(q, size);
        TIntArrayList ret = new TIntArrayList(q.size());
        for (FolderObject fo : q) {
            int folderId = fo.getObjectID();
            if (!set.containsKey(folderId)) continue;
            ret.add(folderId);
        }
        return ret.toArray();
    }

    public static List<FolderIdNamePair> getSharedPrefixFolderSubfolders(String folderIdentifier, User user, UserConfiguration userConfiguration, Context ctx, Connection con) throws OXException {
        int sharedOwner;
        try {
            sharedOwner = Integer.parseInt(folderIdentifier.substring(2));
        }
        catch (NumberFormatException exc) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(exc, exc.getMessage());
        }
        Queue<FolderObject> q = ((FolderObjectIterator)OXFolderIteratorSQL.getVisibleSharedFolders(user.getId(), user.getGroups(), userConfiguration.getAccessibleModules(), sharedOwner, ctx, null, con)).asQueue();
        if (q.isEmpty()) {
            return Collections.emptyList();
        }
        int size = q.size();
        TIntObjectMap<FolderObject> set = SharedPrefixFolder.getFirstLevelSharedFolders(q, size);
        ArrayList<FolderIdNamePair> ret = new ArrayList<FolderIdNamePair>(size);
        for (FolderObject fo : q) {
            int folderId = fo.getObjectID();
            if (!set.containsKey(folderId)) continue;
            ret.add(new FolderIdNamePair(folderId, fo.getFolderName()));
        }
        return ret;
    }

    private static TIntObjectMap<FolderObject> getFirstLevelSharedFolders(Queue<FolderObject> q, int size) {
        TIntObjectHashMap map = new TIntObjectHashMap(size);
        for (FolderObject fo : q) {
            map.put(fo.getObjectID(), (Object)fo);
        }
        TIntArrayList toRemove = new TIntArrayList(size >> 1);
        map.forEachValue((TObjectProcedure)new DetectDirectSubfoldersProcedure((TIntObjectMap<FolderObject>)map, (TIntList)toRemove));
        toRemove.forEach((TIntProcedure)new RemovingProcedure((TIntObjectMap<FolderObject>)map));
        return map;
    }

    private static final class DetectDirectSubfoldersProcedure
    implements TObjectProcedure<FolderObject> {
        private final TIntObjectMap<FolderObject> map;
        private final TIntList toRemove;

        public DetectDirectSubfoldersProcedure(TIntObjectMap<FolderObject> map, TIntList toRemove) {
            this.map = map;
            this.toRemove = toRemove;
        }

        public boolean execute(FolderObject folder) {
            int parent = folder.getParentFolderID();
            if (this.map.containsKey(parent)) {
                this.toRemove.add(folder.getObjectID());
            }
            return true;
        }
    }

    private static final class RemovingProcedure
    implements TIntProcedure {
        private final TIntObjectMap<FolderObject> map;

        public RemovingProcedure(TIntObjectMap<FolderObject> map) {
            this.map = map;
        }

        public boolean execute(int folderId) {
            this.map.remove(folderId);
            return true;
        }
    }
}

