/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database;

import com.openexchange.folderstorage.Permission;
import com.openexchange.server.impl.OCLPermission;

public final class DatabasePermission
implements Permission {
    private int system;
    private int deletePermission;
    private int folderPermission;
    private int readPermission;
    private int writePermission;
    private boolean admin;
    private int entity;
    private boolean group;

    public DatabasePermission() {
    }

    public DatabasePermission(OCLPermission oclPermission) {
        this.admin = oclPermission.isFolderAdmin();
        this.deletePermission = oclPermission.getDeletePermission();
        this.entity = oclPermission.getEntity();
        this.folderPermission = oclPermission.getFolderPermission();
        this.group = oclPermission.isGroupPermission();
        this.readPermission = oclPermission.getReadPermission();
        this.system = oclPermission.getSystem();
        this.writePermission = oclPermission.getWritePermission();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.admin ? 1231 : 1237);
        result = 31 * result + this.deletePermission;
        result = 31 * result + this.entity;
        result = 31 * result + this.folderPermission;
        result = 31 * result + (this.group ? 1231 : 1237);
        result = 31 * result + this.readPermission;
        result = 31 * result + this.system;
        result = 31 * result + this.writePermission;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)obj;
        if (this.admin != other.isAdmin()) {
            return false;
        }
        if (this.deletePermission != other.getDeletePermission()) {
            return false;
        }
        if (this.entity != other.getEntity()) {
            return false;
        }
        if (this.folderPermission != other.getFolderPermission()) {
            return false;
        }
        if (this.group != other.isGroup()) {
            return false;
        }
        if (this.readPermission != other.getReadPermission()) {
            return false;
        }
        if (this.system != other.getSystem()) {
            return false;
        }
        return this.writePermission == other.getWritePermission();
    }

    @Override
    public int getDeletePermission() {
        return this.deletePermission;
    }

    @Override
    public int getEntity() {
        return this.entity;
    }

    @Override
    public int getFolderPermission() {
        return this.folderPermission;
    }

    @Override
    public int getReadPermission() {
        return this.readPermission;
    }

    @Override
    public int getSystem() {
        return this.system;
    }

    @Override
    public int getWritePermission() {
        return this.writePermission;
    }

    @Override
    public boolean isAdmin() {
        return this.admin;
    }

    @Override
    public boolean isGroup() {
        return this.group;
    }

    @Override
    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    @Override
    public void setAllPermissions(int folderPermission, int readPermission, int writePermission, int deletePermission) {
        this.folderPermission = folderPermission;
        this.readPermission = readPermission;
        this.deletePermission = deletePermission;
        this.writePermission = writePermission;
    }

    @Override
    public void setDeletePermission(int permission) {
        this.deletePermission = permission;
    }

    @Override
    public void setEntity(int entity) {
        this.entity = entity;
    }

    @Override
    public void setFolderPermission(int permission) {
        this.folderPermission = permission;
    }

    @Override
    public void setGroup(boolean group) {
        this.group = group;
    }

    @Override
    public void setMaxPermissions() {
        this.folderPermission = 128;
        this.readPermission = 128;
        this.deletePermission = 128;
        this.writePermission = 128;
        this.admin = true;
    }

    @Override
    public void setNoPermissions() {
        this.folderPermission = 0;
        this.readPermission = 0;
        this.deletePermission = 0;
        this.writePermission = 0;
        this.admin = false;
    }

    @Override
    public void setReadPermission(int permission) {
        this.readPermission = permission;
    }

    @Override
    public void setSystem(int system) {
        this.system = system;
    }

    @Override
    public void setWritePermission(int permission) {
        this.writePermission = permission;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    @Override
    public boolean isVisible() {
        return this.isAdmin() || this.getFolderPermission() > 0;
    }
}

