/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency;

import com.openexchange.consistency.ConsistencyExceptionCodes;
import com.openexchange.consistency.ConsistencyMBean;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentExceptionCodes;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.database.impl.DatabaseImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.log.LogFactory;
import com.openexchange.report.internal.Tools;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.QuotaFileStorage;
import com.openexchange.tools.sql.DBUtils;
import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.management.MBeanException;
import org.apache.commons.logging.Log;

public abstract class Consistency
implements ConsistencyMBean {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Consistency.class));

    @Override
    public List<String> listMissingFilesInContext(int contextId) throws MBeanException {
        try {
            LOG.info((Object)("Listing missing files in context " + contextId));
            DoNothingSolver doNothing = new DoNothingSolver();
            RecordSolver recorder = new RecordSolver();
            Context ctx = this.getContext(contextId);
            this.checkOneContext(ctx, recorder, recorder, recorder, doNothing, this.getDatabase(), this.getAttachments(), this.getFileStorage(ctx));
            return recorder.getProblems();
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<Integer, List<String>> listMissingFilesInFilestore(int filestoreId) throws MBeanException {
        try {
            LOG.info((Object)("Listing missing files in filestore " + filestoreId));
            return this.listMissing(this.getContextsForFilestore(filestoreId));
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<Integer, List<String>> listMissingFilesInDatabase(int databaseId) throws MBeanException {
        try {
            LOG.info((Object)("List missing files in database " + databaseId));
            return this.listMissing(this.getContextsForDatabase(databaseId));
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<Integer, List<String>> listAllMissingFiles() throws MBeanException {
        try {
            LOG.info((Object)"List all missing files");
            return this.listMissing(this.getAllContexts());
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<String> listUnassignedFilesInContext(int contextId) throws MBeanException {
        try {
            LOG.info((Object)("List all unassigned files in context " + contextId));
            DoNothingSolver doNothing = new DoNothingSolver();
            RecordSolver recorder = new RecordSolver();
            Context ctx = this.getContext(contextId);
            this.checkOneContext(ctx, doNothing, doNothing, doNothing, recorder, this.getDatabase(), this.getAttachments(), this.getFileStorage(ctx));
            return recorder.getProblems();
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<Integer, List<String>> listUnassignedFilesInFilestore(int filestoreId) throws MBeanException {
        try {
            LOG.info((Object)("List all unassigned files in filestore " + filestoreId));
            return this.listUnassigned(this.getContextsForFilestore(filestoreId));
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<Integer, List<String>> listUnassignedFilesInDatabase(int databaseId) throws MBeanException {
        try {
            LOG.info((Object)("List all unassigned files in database " + databaseId));
            return this.listUnassigned(this.getContextsForDatabase(databaseId));
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<Integer, List<String>> listAllUnassignedFiles() throws MBeanException {
        try {
            LOG.info((Object)"List all unassigned files");
            return this.listUnassigned(this.getAllContexts());
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteContextFromConfigDB(Connection configCon, int contextId) throws SQLException {
        PreparedStatement stmt = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Deleting context_server2dbpool mapping for context " + contextId));
            }
            stmt = configCon.prepareStatement("DELETE FROM context_server2db_pool WHERE cid=?");
            stmt.setInt(1, contextId);
            stmt.executeUpdate();
            stmt.close();
            try {
                Database.reset(contextId);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Deleting login2context entries for context " + contextId));
            }
            stmt = configCon.prepareStatement("DELETE FROM login2context WHERE cid=?");
            stmt.setInt(1, contextId);
            stmt.executeUpdate();
            stmt.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Deleting context entry for context " + contextId));
            }
            stmt = configCon.prepareStatement("DELETE FROM context WHERE cid=?");
            stmt.setInt(1, contextId);
            stmt.executeUpdate();
            stmt.close();
        }
        finally {
            if (null != stmt) {
                stmt.close();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> checkOrRepairConfigDB(boolean repair) throws MBeanException {
        ArrayList<String> i$;
        if (repair) {
            LOG.info((Object)"Repair inconsistent configdb");
        } else {
            LOG.info((Object)"List inconsistent configdb");
        }
        Connection confCon = null;
        Connection poolCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<String> ret = new ArrayList<String>();
        HashMap schemaMap = new HashMap();
        try {
            List ctxs;
            Map<String, Integer> schemaPoolMap = Tools.getAllSchemata(LOG);
            confCon = Database.get(false);
            stmt = confCon.prepareStatement("SELECT db_schema,cid FROM context_server2db_pool");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String schema = rs.getString(1);
                Integer ctx = rs.getInt(2);
                if (schemaMap.containsKey(schema)) {
                    ((List)schemaMap.get(schema)).add(ctx);
                    continue;
                }
                ctxs = new ArrayList<Integer>();
                ctxs.add(ctx);
                schemaMap.put(schema, ctxs);
            }
            DBUtils.closeSQLStuff(rs, stmt);
            stmt = null;
            for (String schema : schemaMap.keySet()) {
                ctxs = (List)schemaMap.get(schema);
                Integer poolid = schemaPoolMap.get(schema);
                poolCon = Database.get((int)poolid, schema);
                String contextids = "";
                for (Integer c : ctxs) {
                    contextids = contextids + c + ",";
                }
                contextids = contextids.substring(0, contextids.length() - 1);
                stmt = poolCon.prepareStatement("SELECT cid FROM login2user WHERE cid IN (" + contextids + ") GROUP BY cid");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    Integer ctx = rs.getInt(1);
                    ctxs.remove(ctx);
                }
                if (ctxs.size() > 0) {
                    LOG.info((Object)("Schema " + schema + " is broken"));
                    for (Integer ctx : ctxs) {
                        if (repair) {
                            LOG.info((Object)("Deleting inconsistent entry for context " + ctx + " from configdb"));
                            this.deleteContextFromConfigDB(confCon, ctx);
                            ret.add("Deleted inconsistent entry for context " + ctx + " from configdb");
                            continue;
                        }
                        LOG.info((Object)("Context " + ctx + " does not exist anymore"));
                        ret.add("Context " + ctx + " does not exist anymore");
                    }
                }
                DBUtils.closeSQLStuff(rs, stmt);
                stmt = null;
                Database.back(poolid, poolCon);
                poolCon = null;
            }
            if (ret.size() == 0 && repair) {
                ret.add("there was nothing to repair");
            }
            DBUtils.closeSQLStuff(rs, stmt);
            stmt = null;
            i$ = ret;
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                Exception wrapMe = new Exception(e.getMessage());
                throw new MBeanException(wrapMe, e.getMessage());
                catch (OXException e2) {
                    LOG.error((Object)e2.getMessage(), (Throwable)e2);
                    wrapMe = new Exception(e2.getMessage());
                    throw new MBeanException(wrapMe, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                if (null != confCon) {
                    Database.back(false, confCon);
                }
                if (null != poolCon) {
                    Database.back(false, poolCon);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (null != confCon) {
            Database.back(false, confCon);
        }
        if (null != poolCon) {
            Database.back(false, poolCon);
        }
        return i$;
    }

    private Map<Integer, List<String>> listMissing(List<Context> contexts) throws OXException {
        HashMap<Integer, List<String>> retval = new HashMap<Integer, List<String>>();
        DoNothingSolver doNothing = new DoNothingSolver();
        for (Context ctx : contexts) {
            RecordSolver recorder = new RecordSolver();
            this.checkOneContext(ctx, recorder, recorder, recorder, doNothing, this.getDatabase(), this.getAttachments(), this.getFileStorage(ctx));
            retval.put(ctx.getContextId(), recorder.getProblems());
        }
        return retval;
    }

    private Map<Integer, List<String>> listUnassigned(List<Context> contexts) throws OXException {
        HashMap<Integer, List<String>> retval = new HashMap<Integer, List<String>>();
        DoNothingSolver doNothing = new DoNothingSolver();
        for (Context ctx : contexts) {
            RecordSolver recorder = new RecordSolver();
            this.checkOneContext(ctx, doNothing, doNothing, doNothing, recorder, this.getDatabase(), this.getAttachments(), this.getFileStorage(ctx));
            retval.put(ctx.getContextId(), recorder.getProblems());
        }
        return retval;
    }

    @Override
    public void repairFilesInContext(int contextId, String resolverPolicy) throws MBeanException {
        try {
            ArrayList<Context> repairMe = new ArrayList<Context>();
            repairMe.add(this.getContext(contextId));
            this.repair(repairMe, resolverPolicy);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void repairFilesInFilestore(int filestoreId, String resolverPolicy) throws MBeanException {
        try {
            this.repair(this.getContextsForFilestore(filestoreId), resolverPolicy);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void repairFilesInDatabase(int databaseId, String resolverPolicy) throws MBeanException {
        try {
            this.repair(this.getContextsForDatabase(databaseId), resolverPolicy);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void repairAllFiles(String resolverPolicy) throws MBeanException {
        try {
            this.repair(this.getAllContexts(), resolverPolicy);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void repair(List<Context> contexts, String policy) throws OXException {
        DatabaseImpl database = this.getDatabase();
        AttachmentBase attachments2 = this.getAttachments();
        for (Context ctx : contexts) {
            FileStorage storage = this.getFileStorage(ctx);
            ResolverPolicy resolvers = ResolverPolicy.parse(policy, database, attachments2, storage, this);
            this.checkOneContext(ctx, resolvers.dbsolver, resolvers.attachmentsolver, resolvers.snippetsolver, resolvers.filesolver, database, attachments2, storage);
            this.recalculateUsage(storage);
        }
    }

    private void output(String text) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)text);
        }
    }

    private void erroroutput(Exception e) {
        LOG.error((Object)e.getMessage(), (Throwable)e);
    }

    private void outputSet(SortedSet<String> set) {
        Iterator itstr = set.iterator();
        StringBuilder sb = new StringBuilder();
        while (itstr.hasNext()) {
            sb.append((String)itstr.next()).append('\n');
        }
        this.output(sb.toString());
    }

    private boolean diffset(SortedSet<String> first, SortedSet<String> second, String name, String name2) {
        boolean retval = false;
        first.removeAll(second);
        if (!first.isEmpty()) {
            this.output("Inconsistencies found in " + name + ", the following files aren't in " + name2 + ':');
            this.outputSet(first);
            retval = true;
        }
        return retval;
    }

    private void checkOneContext(Context ctx, ProblemSolver dbSolver, ProblemSolver attachmentSolver, ProblemSolver snippetSolver, ProblemSolver fileSolver, DatabaseImpl database, AttachmentBase attach, FileStorage stor) throws OXException {
        LOG.info((Object)("Checking context " + ctx.getContextId() + ". Using solvers db: " + dbSolver.description() + " attachments: " + attachmentSolver.description() + " snippets: " + snippetSolver.description() + " files: " + fileSolver.description()));
        stor.recreateStateFile();
        LOG.info((Object)"Listing all files in filestore");
        SortedSet<String> filestoreset = stor.getFileList();
        LOG.info((Object)("Found " + filestoreset.size() + " files in the filestore for this context"));
        LOG.info((Object)"Loading all attachments");
        SortedSet<String> attachmentset = attach.getAttachmentFileStoreLocationsperContext(ctx);
        LOG.info((Object)("Found " + attachmentset.size() + " attachments"));
        SortedSet<String> snippetset = this.getSnippetFileStoreLocationsperContext(ctx);
        LOG.info((Object)("Found " + attachmentset.size() + " attachments"));
        try {
            LOG.info((Object)"Loading all infostore filestore locations");
            SortedSet<String> dbfileset = database.getDocumentFileStoreLocationsperContext(ctx);
            LOG.info((Object)("Found " + dbfileset.size() + " infostore filepaths"));
            TreeSet<String> joineddbfileset = new TreeSet<String>(dbfileset);
            joineddbfileset.addAll(attachmentset);
            joineddbfileset.addAll(snippetset);
            LOG.info((Object)("Found " + joineddbfileset.size() + " filestore ids in total. There are " + filestoreset.size() + " files in the filespool. A difference of " + Math.abs(joineddbfileset.size() - filestoreset.size())));
            if (this.diffset(dbfileset, filestoreset, "database list", "filestore list")) {
                dbSolver.solve(ctx, dbfileset);
            }
            if (this.diffset(attachmentset, filestoreset, "database list of attachment files", "filestore list")) {
                attachmentSolver.solve(ctx, attachmentset);
            }
            if (this.diffset(snippetset, filestoreset, "database list of snippet files", "filestore list")) {
                snippetSolver.solve(ctx, snippetset);
            }
            if (this.diffset(filestoreset, joineddbfileset, "filestore list", "one of the databases")) {
                fileSolver.solve(ctx, filestoreset);
            }
        }
        catch (OXException e) {
            this.erroroutput((Exception)((Object)e));
        }
    }

    private SortedSet<String> getSnippetFileStoreLocationsperContext(Context ctx) throws OXException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection wcon;
        TreeSet<String> retval;
        block9: {
            retval = new TreeSet<String>();
            wcon = null;
            stmt = null;
            rs = null;
            try {
                wcon = Database.get(ctx, true);
                if (Consistency.tableExists(wcon, "snippet")) {
                    stmt = wcon.prepareStatement("SELECT refId FROM snippet WHERE cid=? AND refType=1");
                    stmt.setInt(1, ctx.getContextId());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        retval.add(rs.getString(1));
                    }
                    DBUtils.closeSQLStuff(rs, stmt);
                    stmt = null;
                }
                if (!Consistency.tableExists(wcon, "snippetAttachment")) break block9;
                stmt = wcon.prepareStatement("SELECT referenceId FROM snippetAttachment WHERE cid=?");
                stmt.setInt(1, ctx.getContextId());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    retval.add(rs.getString(1));
                }
                DBUtils.closeSQLStuff(rs, stmt);
                stmt = null;
            }
            catch (SQLException e) {
                try {
                    throw AttachmentExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    if (null != wcon) {
                        Database.back(ctx, true, wcon);
                    }
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (null != wcon) {
            Database.back(ctx, true, wcon);
        }
        return retval;
    }

    private void recalculateUsage(FileStorage storage) {
        try {
            if (storage instanceof QuotaFileStorage) {
                this.output("Recalculating usage...");
                ((QuotaFileStorage)storage).recalculateUsage();
            }
        }
        catch (OXException e) {
            this.erroroutput((Exception)((Object)e));
        }
    }

    protected abstract Context getContext(int var1) throws OXException;

    protected abstract DatabaseImpl getDatabase();

    protected abstract AttachmentBase getAttachments();

    protected abstract FileStorage getFileStorage(Context var1) throws OXException;

    protected abstract List<Context> getContextsForFilestore(int var1) throws OXException;

    protected abstract List<Context> getContextsForDatabase(int var1) throws OXException;

    protected abstract List<Context> getAllContexts() throws OXException;

    protected abstract User getAdmin(Context var1) throws OXException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean tableExists(Connection con, String table) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet rs = null;
        boolean retval = false;
        try {
            rs = metaData.getTables(null, null, table, new String[]{"TABLE"});
            retval = rs.next() && rs.getString("TABLE_NAME").equals(table);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs);
        return retval;
    }

    private static class CreateInfoitem
    implements ProblemSolver {
        private static final Log LOG1 = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CreateInfoitem.class));
        private static final String description = "This file needs attention";
        private static final String title = "Restoredfile";
        private static final String fileName = "Restoredfile";
        private static final String versioncomment = "";
        private static final String categories = "";
        private final DatabaseImpl database;
        private final FileStorage storage;
        private final Consistency consistency;

        public CreateInfoitem(DatabaseImpl database, FileStorage storage, Consistency consistency) {
            this.database = database;
            this.storage = storage;
            this.consistency = consistency;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void solve(Context ctx, Set<String> problems) throws OXException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public String description() {
            return "create infoitem";
        }
    }

    private static class DeleteSnippet
    implements ProblemSolver {
        private static final Log LOG1 = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(DeleteSnippet.class));

        /*
         * Exception decompiling
         */
        @Override
        public void solve(Context ctx, Set<String> problems) throws OXException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteSnippet(int id, int userId, int contextId, Connection con) {
            PreparedStatement stmt = null;
            try {
                int confId;
                stmt = con.prepareStatement("DELETE FROM snippetAttachment WHERE cid=? AND user=? AND id=?");
                int pos = 0;
                stmt.setLong(++pos, contextId);
                stmt.setLong(++pos, userId);
                stmt.setLong(++pos, id);
                stmt.executeUpdate();
                DBUtils.closeSQLStuff(stmt);
                stmt = null;
                stmt = con.prepareStatement("DELETE FROM snippetContent WHERE cid=? AND user=? AND id=?");
                pos = 0;
                stmt.setLong(++pos, contextId);
                stmt.setLong(++pos, userId);
                stmt.setLong(++pos, id);
                stmt.executeUpdate();
                DBUtils.closeSQLStuff(stmt);
                stmt = null;
                stmt = con.prepareStatement("DELETE FROM snippetMisc WHERE cid=? AND user=? AND id=?");
                pos = 0;
                stmt.setLong(++pos, contextId);
                stmt.setLong(++pos, userId);
                stmt.setLong(++pos, id);
                stmt.executeUpdate();
                DBUtils.closeSQLStuff(stmt);
                stmt = null;
                ResultSet rs = null;
                try {
                    stmt = con.prepareStatement("SELECT refId FROM snippet WHERE cid=? AND user=? AND id=? AND refType=0");
                    pos = 0;
                    stmt.setLong(++pos, contextId);
                    stmt.setLong(++pos, userId);
                    stmt.setString(++pos, Integer.toString(id));
                    rs = stmt.executeQuery();
                    confId = rs.next() ? Integer.parseInt(rs.getString(1)) : -1;
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    stmt = null;
                    rs = null;
                    throw throwable;
                }
                DBUtils.closeSQLStuff(rs, stmt);
                stmt = null;
                rs = null;
                if (confId > 0) {
                    stmt = con.prepareStatement("DELETE FROM genconf_attributes_strings WHERE cid = ? AND id = ?");
                    pos = 0;
                    stmt.setLong(++pos, contextId);
                    stmt.setLong(++pos, confId);
                    stmt.executeUpdate();
                    DBUtils.closeSQLStuff(stmt);
                    stmt = con.prepareStatement("DELETE FROM genconf_attributes_bools WHERE cid = ? AND id = ?");
                    pos = 0;
                    stmt.setLong(++pos, contextId);
                    stmt.setLong(++pos, confId);
                    stmt.executeUpdate();
                    DBUtils.closeSQLStuff(stmt);
                }
                stmt = con.prepareStatement("DELETE FROM snippet WHERE cid=? AND user=? AND id=? AND refType=0");
                pos = 0;
                stmt.setLong(++pos, contextId);
                stmt.setLong(++pos, userId);
                stmt.setString(++pos, Integer.toString(id));
                stmt.executeUpdate();
                DBUtils.closeSQLStuff(stmt);
                stmt = null;
            }
            catch (SQLException e) {
                LOG1.error((Object)"", (Throwable)e);
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
        }

        @Override
        public String description() {
            return "delete snippet";
        }
    }

    private static class DeleteAttachment
    implements ProblemSolver {
        private static final Log LOG1 = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(DeleteAttachment.class));
        private final AttachmentBase attachments;

        public DeleteAttachment(AttachmentBase attachments2) {
            this.attachments = attachments2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void solve(Context ctx, Set<String> problems) throws OXException {
            Iterator<String> it = problems.iterator();
            while (it.hasNext()) {
                try {
                    String identifier = it.next();
                    this.attachments.setTransactional(true);
                    this.attachments.startTransaction();
                    int[] numbers = this.attachments.removeAttachment(identifier, ctx);
                    this.attachments.commit();
                    if (numbers[0] == 1 && LOG1.isInfoEnabled()) {
                        LOG1.info((Object)("Inserted entry for identifier " + identifier + " and Context " + ctx.getContextId() + " in " + "del_attachments"));
                    }
                    if (numbers[1] != 1 || !LOG1.isInfoEnabled()) continue;
                    LOG1.info((Object)("Removed attachment database entry for: " + identifier));
                }
                catch (OXException e) {
                    LOG1.debug((Object)"", (Throwable)e);
                    try {
                        this.attachments.rollback();
                        return;
                    }
                    catch (OXException e1) {
                        LOG1.debug((Object)"", (Throwable)e1);
                        return;
                    }
                }
                catch (RuntimeException e) {
                    LOG1.error((Object)"", (Throwable)e);
                    try {
                        this.attachments.rollback();
                        return;
                    }
                    catch (OXException e1) {
                        LOG1.debug((Object)"", (Throwable)e1);
                        return;
                    }
                }
                finally {
                    try {
                        this.attachments.finish();
                    }
                    catch (OXException e) {
                        LOG1.debug((Object)"", (Throwable)e);
                    }
                }
            }
        }

        @Override
        public String description() {
            return "delete attachment";
        }
    }

    private static class DeleteInfoitem
    implements ProblemSolver {
        private static final Log LOG1 = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(DeleteInfoitem.class));
        private final DatabaseImpl database;

        public DeleteInfoitem(DatabaseImpl database) {
            this.database = database;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void solve(Context ctx, Set<String> problems) throws OXException {
            for (String identifier : problems) {
                block18: {
                    this.database.startTransaction();
                    this.database.startDBTransaction();
                    this.database.setRequestTransactional(true);
                    int[] numbers = this.database.removeDocument(identifier, ctx);
                    this.database.commit();
                    if (numbers[0] == 1 && LOG1.isInfoEnabled()) {
                        LOG1.info((Object)("Have to change infostore version number for entry: " + identifier));
                    }
                    if (numbers[1] != 1 || !LOG1.isInfoEnabled()) break block18;
                    LOG1.info((Object)("Deleted entry " + identifier + " from " + "infostore_documents."));
                }
                try {
                    this.database.finish();
                }
                catch (OXException e) {
                    LOG1.debug((Object)"", (Throwable)e);
                }
                continue;
                catch (OXException e) {
                    LOG1.error((Object)"", (Throwable)e);
                    this.database.rollback();
                    try {
                        this.database.finish();
                    }
                    catch (OXException e2) {
                        LOG1.debug((Object)"", (Throwable)e2);
                    }
                    return;
                    {
                        catch (OXException e1) {
                            try {
                                LOG1.debug((Object)"", (Throwable)e1);
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                try {
                                    this.database.finish();
                                }
                                catch (OXException e3) {
                                    LOG1.debug((Object)"", (Throwable)e3);
                                }
                            }
                        }
                    }
                }
            }
        }

        @Override
        public String description() {
            return "delete infoitem";
        }
    }

    private static class RemoveFile
    implements ProblemSolver {
        private static final Log LOG1 = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(RemoveFile.class));
        private final FileStorage storage;

        public RemoveFile(FileStorage storage) {
            this.storage = storage;
        }

        @Override
        public void solve(Context ctx, Set<String> problems) throws OXException {
            try {
                for (String identifier : problems) {
                    if (!this.storage.deleteFile(identifier) || !LOG1.isInfoEnabled()) continue;
                    LOG1.info((Object)("Deleted identifier: " + identifier));
                }
                this.storage.recreateStateFile();
            }
            catch (OXException e) {
                LOG1.error((Object)"", (Throwable)e);
            }
        }

        @Override
        public String description() {
            return "delete file";
        }
    }

    private static class CreateDummyFileForSnippet
    extends CreateDummyFile
    implements ProblemSolver {
        private static final Log LOG1 = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CreateDummyFileForSnippet.class));

        public CreateDummyFileForSnippet(FileStorage storage) {
            super(storage);
        }

        /*
         * Exception decompiling
         */
        @Override
        public void solve(Context ctx, Set<String> problems) throws OXException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public String description() {
            return "Create dummy file for snippet";
        }
    }

    private static class CreateDummyFileForAttachment
    extends CreateDummyFile
    implements ProblemSolver {
        private static final Log LOG1 = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CreateDummyFileForAttachment.class));
        private final AttachmentBase attachments;

        public CreateDummyFileForAttachment(AttachmentBase attachments2, FileStorage storage) {
            super(storage);
            this.attachments = attachments2;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void solve(Context ctx, Set<String> problems) throws OXException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public String description() {
            return "Create dummy file for attachment";
        }
    }

    private static class CreateDummyFileForInfoitem
    extends CreateDummyFile
    implements ProblemSolver {
        private static final Log LOG1 = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CreateDummyFileForInfoitem.class));
        private final DatabaseImpl database;

        public CreateDummyFileForInfoitem(DatabaseImpl database, FileStorage storage) {
            super(storage);
            this.database = database;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void solve(Context ctx, Set<String> problems) throws OXException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public String description() {
            return "Create dummy file for infoitem";
        }
    }

    private static class CreateDummyFile {
        private final FileStorage storage;

        public CreateDummyFile(FileStorage storage) {
            this.storage = storage;
        }

        protected String createDummyFile() throws OXException {
            String filetext = "This is just a dummy file";
            ByteArrayInputStream input = new ByteArrayInputStream("This is just a dummy file".getBytes());
            return this.storage.saveNewFile(input);
        }
    }

    private static class RecordSolver
    implements ProblemSolver {
        private final List<String> memory = new ArrayList<String>();

        @Override
        public void solve(Context ctx, Set<String> problems) throws OXException {
            this.memory.addAll(problems);
        }

        @Override
        public String description() {
            return "Remember in List";
        }

        public List<String> getProblems() {
            return this.memory;
        }
    }

    private static class DoNothingSolver
    implements ProblemSolver {
        @Override
        public void solve(Context ctx, Set<String> problems) throws OXException {
        }

        @Override
        public String description() {
            return "Do Nothing";
        }
    }

    private static interface ProblemSolver {
        public void solve(Context var1, Set<String> var2) throws OXException;

        public String description();
    }

    private static final class ResolverPolicy {
        final ProblemSolver dbsolver;
        final ProblemSolver attachmentsolver;
        final ProblemSolver snippetsolver;
        final ProblemSolver filesolver;

        public ResolverPolicy(ProblemSolver dbsolver, ProblemSolver attachmentsolver, ProblemSolver snippetsolver, ProblemSolver filesolver) {
            this.dbsolver = dbsolver;
            this.attachmentsolver = attachmentsolver;
            this.snippetsolver = snippetsolver;
            this.filesolver = filesolver;
        }

        public static ResolverPolicy parse(String list, DatabaseImpl database, AttachmentBase attach, FileStorage stor, Consistency consistency) throws OXException {
            String[] options = list.split("\\s*,\\s*");
            ProblemSolver dbsolver = new DoNothingSolver();
            ProblemSolver attachmentsolver = new DoNothingSolver();
            ProblemSolver snippetsolver = new DoNothingSolver();
            ProblemSolver filesolver = new DoNothingSolver();
            for (String option : options) {
                String[] tuple = option.split("\\s*:\\s*");
                if (tuple.length != 2) {
                    throw ConsistencyExceptionCodes.MALFORMED_POLICY.create();
                }
                String condition = tuple[0];
                String action = tuple[1];
                if ("missing_file_for_infoitem".equals(condition)) {
                    if ("create_dummy".equals(action)) {
                        dbsolver = new CreateDummyFileForInfoitem(database, stor);
                        continue;
                    }
                    if ("delete".equals(action)) {
                        dbsolver = new DeleteInfoitem(database);
                        continue;
                    }
                    dbsolver = new DoNothingSolver();
                    continue;
                }
                if ("missing_file_for_attachment".equals(condition)) {
                    if ("create_dummy".equals(action)) {
                        attachmentsolver = new CreateDummyFileForAttachment(attach, stor);
                        continue;
                    }
                    if ("delete".equals(action)) {
                        attachmentsolver = new DeleteAttachment(attach);
                        continue;
                    }
                    attachmentsolver = new DoNothingSolver();
                    continue;
                }
                if ("missing_file_for_snippet".equals(condition)) {
                    if ("create_dummy".equals(action)) {
                        snippetsolver = new CreateDummyFileForSnippet(stor);
                        continue;
                    }
                    if ("delete".equals(action)) {
                        snippetsolver = new DeleteSnippet();
                        continue;
                    }
                    snippetsolver = new DoNothingSolver();
                    continue;
                }
                if (!"missing_entry_for_file".equals(condition)) continue;
                filesolver = "create_admin_infoitem".equals(action) ? new CreateInfoitem(database, stor, consistency) : ("delete".equals(action) ? new RemoveFile(stor) : new DoNothingSolver());
            }
            return new ResolverPolicy(dbsolver, attachmentsolver, snippetsolver, filesolver);
        }
    }
}

