/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers;

import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.helper.DownloadUtility;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import com.openexchange.ajax.requesthandler.Utils;
import com.openexchange.exception.Log;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.tools.images.ImageTransformationService;
import com.openexchange.tools.images.ImageTransformations;
import com.openexchange.tools.images.ScaleType;
import com.openexchange.tools.servlet.http.Tools;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileResponseRenderer
implements ResponseRenderer {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(FileResponseRenderer.class));
    private static final int BUFLEN = 2048;
    private static final String PARAMETER_CONTENT_DISPOSITION = "content_disposition";
    private static final String PARAMETER_CONTENT_TYPE = "content_type";
    private static final String SAVE_AS_TYPE = "application/octet-stream";
    private volatile ImageTransformationService scaler;
    private static final String DELIVERY = "delivery";
    private static final String DOWNLOAD = "download";
    private static final String VIEW = "view";

    @Override
    public int getRanking() {
        return 0;
    }

    public void setScaler(ImageTransformationService scaler) {
        this.scaler = scaler;
    }

    @Override
    public boolean handles(AJAXRequestData request, AJAXRequestResult result) {
        return result.getResultObject() instanceof IFileHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(AJAXRequestData request, AJAXRequestResult result, HttpServletRequest req, HttpServletResponse resp) {
        InputStream documentData;
        IFileHolder file;
        block34: {
            block33: {
                file = (IFileHolder)result.getResultObject();
                String fileName = file.getName();
                documentData = null;
                try {
                    int read;
                    String contentDisposition;
                    String delivery;
                    String fileContentType = file.getContentType();
                    String contentType = req.getParameter(PARAMETER_CONTENT_TYPE);
                    if (null == contentType) {
                        contentType = fileContentType;
                    }
                    if ((delivery = req.getParameter(DELIVERY)) == null) {
                        delivery = file.getDelivery();
                    }
                    contentDisposition = null == (contentDisposition = req.getParameter(PARAMETER_CONTENT_DISPOSITION)) ? file.getDisposition() : Utils.encodeUrl(contentDisposition);
                    if (null == (file = this.transformIfImage(request, file, delivery))) {
                        resp.sendError(404, "Image not found.");
                        return;
                    }
                    InputStream inputStream = documentData = null == file.getStream() ? null : new BufferedInputStream(file.getStream());
                    if (null == documentData) {
                        resp.sendError(404, "Image not found.");
                        Streams.close((Closeable)file);
                        break block33;
                    }
                    String userAgent = req.getHeader("user-agent");
                    if (SAVE_AS_TYPE.equals(contentType) || DOWNLOAD.equalsIgnoreCase(delivery)) {
                        StringBuilder sb = new StringBuilder(32);
                        sb.append(this.isEmpty(contentDisposition) ? "attachment" : this.checkedContentDisposition(contentDisposition.trim(), file));
                        DownloadUtility.appendFilenameParameter(file.getName(), null, userAgent, sb);
                        resp.setHeader("Content-Disposition", sb.toString());
                        resp.setContentType(null == contentType ? SAVE_AS_TYPE : contentType);
                    } else {
                        String cts = null == fileContentType ? MimeType2ExtMap.getContentType(fileName) : fileContentType;
                        DownloadUtility.CheckedDownload checkedDownload = DownloadUtility.checkInlineDownload(documentData, fileName, cts, contentDisposition, userAgent);
                        if (delivery == null || !delivery.equalsIgnoreCase(VIEW)) {
                            if (this.isEmpty(contentDisposition)) {
                                resp.setHeader("Content-Disposition", checkedDownload.getContentDisposition());
                            } else if (contentDisposition.indexOf(59) >= 0) {
                                resp.setHeader("Content-Disposition", contentDisposition.trim());
                            } else {
                                String disposition = checkedDownload.getContentDisposition();
                                int pos = disposition.indexOf(59);
                                if (pos >= 0) {
                                    resp.setHeader("Content-Disposition", contentDisposition.trim() + disposition.substring(pos));
                                } else {
                                    resp.setHeader("Content-Disposition", contentDisposition.trim());
                                }
                            }
                        }
                        if (contentType == null) {
                            resp.setContentType(checkedDownload.getContentType());
                        } else {
                            String checkedContentType = checkedDownload.getContentType();
                            if (SAVE_AS_TYPE.equals(checkedContentType)) {
                                resp.setContentType(contentType);
                            } else {
                                String primaryType1 = this.getPrimaryType(checkedContentType);
                                String primaryType2 = this.getPrimaryType(contentType);
                                if (this.toLowerCase(primaryType1).startsWith(this.toLowerCase(primaryType2))) {
                                    resp.setContentType(contentType);
                                } else {
                                    StringAllocator sb = new StringAllocator(128);
                                    sb.append("Denied parameter \"").append(PARAMETER_CONTENT_TYPE).append("\" due to security constraints (");
                                    sb.append(contentType).append(" vs. ").append(checkedContentType).append(").");
                                    LOG.warn((Object)sb.toString());
                                    resp.setContentType(checkedContentType);
                                }
                            }
                        }
                        documentData = checkedDownload.getInputStream();
                    }
                    Tools.removeCachingHeader(resp);
                    if (delivery == null || !delivery.equalsIgnoreCase(DOWNLOAD)) {
                        String eTag = result.getHeader("ETag");
                        if (null != eTag) {
                            long expires = result.getExpires();
                            Tools.setETag(eTag, expires > 0L ? new Date(System.currentTimeMillis() + expires) : null, resp);
                        } else {
                            long expires = result.getExpires();
                            if (expires < 0L) {
                                Tools.setExpiresInOneYear(resp);
                            } else if (expires > 0L) {
                                Tools.setExpires(new Date(System.currentTimeMillis() + expires), resp);
                            }
                        }
                    }
                    ServletOutputStream outputStream = resp.getOutputStream();
                    int len = 2048;
                    byte[] buf = new byte[2048];
                    while ((read = documentData.read(buf, 0, 2048)) > 0) {
                        outputStream.write(buf, 0, read);
                    }
                    outputStream.flush();
                    Streams.close((Closeable)file);
                    break block34;
                }
                catch (Exception e) {
                    LOG.error((Object)("Exception while trying to output file" + (this.isEmpty(fileName) ? "" : " " + fileName)), (Throwable)e);
                    return;
                }
            }
            Streams.close((Closeable)documentData);
            return;
        }
        Streams.close((Closeable)documentData);
        return;
        finally {
            Streams.close((Closeable)file);
            Streams.close(documentData);
        }
    }

    private IFileHolder transformIfImage(AJAXRequestData request, IFileHolder file, String delivery) throws IOException, OXException {
        InputStream transformed;
        Boolean compress;
        Boolean rotate;
        boolean markSupported;
        ImageTransformationService scaler = this.scaler;
        if (null == scaler || !this.isImage(file)) {
            return file;
        }
        InputStream stream = file.getStream();
        if (null == stream) {
            LOG.warn((Object)"(Possible) Image file misses stream data");
            return file;
        }
        boolean bl = markSupported = file.repetitive() ? false : stream.markSupported();
        if (markSupported) {
            stream.mark(131072);
        }
        ImageTransformations transformations = scaler.transfom(stream);
        Boolean bl2 = rotate = request.isSet("rotate") ? request.getParameter("rotate", Boolean.class) : null;
        if (null == rotate && !DOWNLOAD.equalsIgnoreCase(delivery) || null != rotate && rotate.booleanValue()) {
            transformations.rotate();
        }
        if (request.isSet("cropWidth") || request.isSet("cropHeight")) {
            int cropX = request.isSet("cropX") ? request.getParameter("cropX", Integer.TYPE) : 0;
            int cropY = request.isSet("cropY") ? request.getParameter("cropY", Integer.TYPE) : 0;
            int cropWidth = request.getParameter("cropWidth", Integer.TYPE);
            int cropHeight = request.getParameter("cropHeight", Integer.TYPE);
            transformations.crop(cropX, cropY, cropWidth, cropHeight);
        }
        if (request.isSet("width") || request.isSet("height")) {
            int maxWidth = request.isSet("width") ? request.getParameter("width", Integer.TYPE) : 0;
            int maxHeight = request.isSet("height") ? request.getParameter("height", Integer.TYPE) : 0;
            ScaleType scaleType = ScaleType.getType(request.getParameter("scaleType"));
            transformations.scale(maxWidth, maxHeight, scaleType);
        }
        Boolean bl3 = compress = request.isSet("compress") ? request.getParameter("compress", Boolean.class) : null;
        if (null == compress && !DOWNLOAD.equalsIgnoreCase(delivery) || null != compress && compress.booleanValue()) {
            transformations.compress();
        }
        if (null == (transformed = transformations.getInputStream(file.getContentType()))) {
            LOG.warn((Object)"Got no resulting input stream from transformation, trying to recover original input");
            if (markSupported) {
                try {
                    stream.reset();
                    return file;
                }
                catch (Exception e) {
                    LOG.warn((Object)"Error resetting input stream", (Throwable)e);
                }
            }
            LOG.error((Object)("Unable to transform image from " + file));
            return file.repetitive() ? file : null;
        }
        return new FileHolder(transformed, -1L, file.getContentType(), file.getName());
    }

    private String checkedContentDisposition(String contentDisposition, IFileHolder file) {
        String ct = this.toLowerCase(file.getContentType());
        if (null == ct || ct.startsWith("text/htm")) {
            int pos = contentDisposition.indexOf(59);
            return pos > 0 ? "attachment" + contentDisposition.substring(pos) : "attachment";
        }
        return contentDisposition;
    }

    private boolean isImage(IFileHolder file) {
        String fileName;
        String contentType = file.getContentType();
        return null != contentType && contentType.startsWith("image/") || (fileName = file.getName()) != null && (contentType = MimeType2ExtMap.getContentType(fileName)).startsWith("image/");
    }

    private String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    private String getPrimaryType(String contentType) {
        if (this.isEmpty(contentType)) {
            return contentType;
        }
        int pos = contentType.indexOf(47);
        return pos > 0 ? contentType.substring(0, pos) : contentType;
    }
}

