/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.container.ByteArrayFileHolder;
import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.AbstractPreviewResultConverter;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.preview.ContentTypeChecker;
import com.openexchange.preview.PreviewDocument;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.preview.PreviewOutput;
import com.openexchange.preview.PreviewService;
import com.openexchange.preview.cache.CachedPreview;
import com.openexchange.preview.cache.PreviewCache;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PreviewImageResultConverter
extends AbstractPreviewResultConverter {
    private static final Set<String> INVALIDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("application/octet-stream", "application/force-download", "application/binary", "application/x-download", "application/octet-stream", "application/vnd", "application/vnd.ms-word.document.12n", "application/vnd.ms-word.document.12", "application/odt", "application/x-pdf")));

    @Override
    public String getOutputFormat() {
        return "preview_image";
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public PreviewOutput getOutput() {
        return PreviewOutput.IMAGE;
    }

    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, final ServerSession session, Converter converter) throws OXException {
        try {
            String cacheKey;
            CachedPreview cachedPreview;
            boolean isValidEtag;
            final PreviewCache previewCache = AbstractPreviewResultConverter.getPreviewCache();
            String eTag = result.getHeader("ETag");
            boolean bl = isValidEtag = !this.isEmpty(eTag);
            if (null != previewCache && isValidEtag && null != (cachedPreview = previewCache.get(cacheKey = this.generatePreviewCacheKey(eTag, requestData, new String[0]), session.getUserId(), session.getContextId()))) {
                InputStream inputStream;
                requestData.setFormat("file");
                String contentType = cachedPreview.getFileType();
                if (null == contentType) {
                    contentType = "image/jpeg";
                }
                if (null == (inputStream = cachedPreview.getInputStream())) {
                    ByteArrayFileHolder responseFileHolder = new ByteArrayFileHolder(cachedPreview.getBytes());
                    responseFileHolder.setContentType(contentType);
                    responseFileHolder.setName(cachedPreview.getFileName());
                    result.setResultObject(responseFileHolder, "file");
                } else {
                    FileHolder responseFileHolder = new FileHolder(inputStream, cachedPreview.getSize(), contentType, cachedPreview.getFileName());
                    result.setResultObject(responseFileHolder, "file");
                }
                return;
            }
            Object resultObject = result.getResultObject();
            if (!(resultObject instanceof IFileHolder)) {
                throw AjaxExceptionCodes.UNEXPECTED_RESULT.create(IFileHolder.class.getSimpleName(), null == resultObject ? "null" : resultObject.getClass().getSimpleName());
            }
            IFileHolder fileHolder = (IFileHolder)resultObject;
            PreviewService previewService = ServerServiceRegistry.getInstance().getService(PreviewService.class);
            DataProperties dataProperties = new DataProperties(7);
            dataProperties.put("com.openexchange.conversion.content-type", this.getContentType(fileHolder, previewService instanceof ContentTypeChecker ? (ContentTypeChecker)previewService : null));
            dataProperties.put("com.openexchange.conversion.disposition", fileHolder.getDisposition());
            dataProperties.put("com.openexchange.conversion.name", fileHolder.getName());
            dataProperties.put("com.openexchange.conversion.size", Long.toString(fileHolder.getLength()));
            dataProperties.put("PreviewType", requestData.getModule().equals("files") ? "DetailView" : "Thumbnail");
            dataProperties.put("PreviewWidth", requestData.getParameter("width"));
            dataProperties.put("PreviewHeight", requestData.getParameter("height"));
            PreviewDocument previewDocument = previewService.getPreviewFor((Data)new SimpleData((Object)fileHolder.getStream(), dataProperties), this.getOutput(), (Session)session, 1);
            requestData.setFormat("file");
            InputStream thumbnail = previewDocument.getThumbnail();
            if (null == thumbnail) {
                throw PreviewExceptionCodes.THUMBNAIL_NOT_AVAILABLE.create();
            }
            final String fileName = (String)previewDocument.getMetaData().get("resourcename");
            int size = -1;
            if (null != previewCache && isValidEtag) {
                final byte[] bytes = Streams.stream2bytes((InputStream)thumbnail);
                thumbnail = Streams.newByteArrayInputStream((byte[])bytes);
                size = bytes.length;
                final String cacheKey2 = this.generatePreviewCacheKey(eTag, requestData, new String[0]);
                AbstractTask<Void> task = new AbstractTask<Void>(){

                    public Void call() throws OXException {
                        CachedPreview preview = new CachedPreview(bytes, fileName, "image/jpeg", (long)bytes.length);
                        previewCache.save(cacheKey2, preview, session.getUserId(), session.getContextId());
                        return null;
                    }
                };
                ThreadPoolService threadPool = ServerServiceRegistry.getInstance().getService(ThreadPoolService.class);
                if (null == threadPool) {
                    Thread thread = Thread.currentThread();
                    boolean ran = false;
                    task.beforeExecute(thread);
                    try {
                        task.call();
                        ran = true;
                        task.afterExecute(null);
                    }
                    catch (Exception ex) {
                        if (!ran) {
                            task.afterExecute((Throwable)ex);
                        }
                        throw ex instanceof OXException ? (OXException)((Object)ex) : AjaxExceptionCodes.UNEXPECTED_ERROR.create(ex, ex.getMessage());
                    }
                } else {
                    threadPool.submit((Task)task);
                }
            }
            FileHolder responseFileHolder = new FileHolder(thumbnail, (long)size, "image/jpeg", fileName);
            result.setResultObject(responseFileHolder, "file");
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private String getContentType(IFileHolder fileHolder, ContentTypeChecker checker) {
        String contentType = fileHolder.getContentType();
        if (this.isEmpty(contentType)) {
            return MimeType2ExtMap.getContentType(fileHolder.getName());
        }
        if (INVALIDS.contains(contentType = this.sanitizeContentType(this.getLowerCaseBaseType(contentType))) || null != checker && !checker.isValid(contentType)) {
            contentType = MimeType2ExtMap.getContentType(fileHolder.getName());
        }
        return contentType == null ? "application/octet-stream" : contentType;
    }

    private String sanitizeContentType(String contentType) {
        if (null == contentType) {
            return null;
        }
        try {
            return new ContentType(contentType).toString();
        }
        catch (OXException e) {
            return contentType;
        }
    }

    private String getLowerCaseBaseType(String contentType) {
        if (null == contentType) {
            return null;
        }
        int pos = contentType.indexOf(59);
        return this.toLowerCase(pos > 0 ? contentType.substring(0, pos) : contentType).trim();
    }

    private String toLowerCase(CharSequence chars) {
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }
}

