/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.container;

import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.MimetypesFileTypeMap;

public class FileHolder
implements IFileHolder {
    private IFileHolder.InputStreamClosure isClosure;
    private InputStream is;
    private long length;
    private String contentType;
    private String name;
    private String disposition;
    private String delivery;

    public FileHolder(InputStream is, long length, String contentType, String name) {
        this.is = is;
        this.length = length;
        this.contentType = contentType;
        this.name = name;
    }

    public FileHolder(IFileHolder.InputStreamClosure isClosure, long length, String contentType, String name) {
        this.isClosure = isClosure;
        this.length = length;
        this.contentType = contentType;
        this.name = name;
    }

    public FileHolder(final File file, String contentType) {
        this.length = file.length();
        if (contentType == null) {
            contentType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(file);
        }
        this.contentType = contentType;
        this.name = file.getName();
        this.isClosure = new IFileHolder.InputStreamClosure(){

            @Override
            public InputStream newStream() throws OXException, IOException {
                return new FileInputStream(file);
            }
        };
    }

    public FileHolder(File file) {
        this(file, null);
    }

    @Override
    public boolean repetitive() {
        return null != this.isClosure;
    }

    @Override
    public void close() {
    }

    @Override
    public InputStream getStream() throws OXException {
        IFileHolder.InputStreamClosure isClosure = this.isClosure;
        if (null != isClosure) {
            try {
                return isClosure.newStream();
            }
            catch (IOException e) {
                throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
        }
        return this.is;
    }

    public void setStream(InputStream is) {
        Streams.close((Closeable)this.is);
        this.is = is;
        this.isClosure = null;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDisposition() {
        return this.disposition;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

    @Override
    public String getDelivery() {
        return this.delivery;
    }
}

