/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic.groupware;

import com.openexchange.database.DatabaseService;
import com.openexchange.datatypes.genericonf.storage.GenericConfigurationStorageService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteFailedExceptionCodes;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.messaging.generic.services.MessagingGenericServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.procedure.TIntProcedure;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class MessagingGenericDeleteListener
implements DeleteListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deletePerformed(DeleteEvent event, Connection readCon, Connection writeCon) throws OXException {
        if (1 != event.getType()) {
            return;
        }
        DatabaseService databaseService = this.getService(DatabaseService.class);
        int contextId = event.getContext().getContextId();
        PreparedStatement stmt = null;
        try {
            Context context;
            GenericConfigurationStorageService genericConfStorageService;
            GenConfDelete gcd;
            TIntArrayList confIds;
            int userId = event.getId();
            ResultSet rs = null;
            try {
                stmt = writeCon.prepareStatement("SELECT confId FROM messagingAccount WHERE cid = ? AND user = ?");
                int pos = 1;
                stmt.setInt(pos++, contextId);
                stmt.setInt(pos++, userId);
                rs = stmt.executeQuery();
                confIds = new TIntArrayList(4);
                while (rs.next()) {
                    confIds.add(rs.getInt(1));
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs);
                throw throwable;
            }
            DBUtils.closeSQLStuff((ResultSet)rs);
            DBUtils.closeSQLStuff((Statement)stmt);
            class GenConfDelete
            implements TIntProcedure {
                OXException genConfError;
                final /* synthetic */ GenericConfigurationStorageService val$genericConfStorageService;
                final /* synthetic */ Connection val$writeCon;
                final /* synthetic */ Context val$context;

                GenConfDelete() {
                    this.val$genericConfStorageService = genericConfigurationStorageService;
                    this.val$writeCon = connection;
                    this.val$context = context;
                }

                public boolean execute(int confId) {
                    try {
                        this.val$genericConfStorageService.delete(this.val$writeCon, this.val$context, confId);
                        return true;
                    }
                    catch (OXException e) {
                        this.genConfError = e;
                        return false;
                    }
                }
            }
            if (!confIds.isEmpty() && !confIds.forEach((TIntProcedure)(gcd = new GenConfDelete())) && null != gcd.genConfError) {
                throw gcd.genConfError;
            }
            stmt = writeCon.prepareStatement("DELETE FROM messagingAccount WHERE cid = ? AND user = ?");
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw DeleteFailedExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                catch (Exception e2) {
                    throw DeleteFailedExceptionCodes.ERROR.create((Throwable)e2, new Object[]{e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff((Statement)stmt);
    }

    private <S> S getService(Class<? extends S> clazz) throws OXException {
        try {
            return MessagingGenericServiceRegistry.getService(clazz);
        }
        catch (RuntimeException e) {
            throw new OXException((Throwable)e);
        }
    }
}

