/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public final class UnsynchronizedPushbackReader
extends FilterReader {
    private char[] buf;
    private int pos;

    public UnsynchronizedPushbackReader(Reader in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new char[size];
        this.pos = size;
    }

    public UnsynchronizedPushbackReader(Reader in) {
        this(in, 1);
    }

    private void ensureOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++];
        }
        return super.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (len <= 0) {
            if (len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (off < 0 || off > cbuf.length) {
                throw new IndexOutOfBoundsException();
            }
            return 0;
        }
        int avail = this.buf.length - this.pos;
        if (avail > 0) {
            if (len < avail) {
                avail = len;
            }
            System.arraycopy(this.buf, this.pos, cbuf, off, avail);
            this.pos += avail;
            off += avail;
            len -= avail;
        }
        if (len > 0) {
            if ((len = super.read(cbuf, off, len)) == -1) {
                return avail == 0 ? -1 : avail;
            }
            return avail + len;
        }
        return avail;
    }

    public void unread(int c) throws IOException {
        this.ensureOpen();
        if (this.pos == 0) {
            throw new IOException("Pushback buffer overflow");
        }
        this.buf[--this.pos] = (char)c;
    }

    public void unread(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (len > this.pos) {
            throw new IOException("Pushback buffer overflow");
        }
        this.pos -= len;
        System.arraycopy(cbuf, off, this.buf, this.pos, len);
    }

    public void unread(char[] cbuf) throws IOException {
        this.unread(cbuf, 0, cbuf.length);
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.pos < this.buf.length || super.ready();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.buf = null;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        this.ensureOpen();
        int avail = this.buf.length - this.pos;
        if (avail > 0) {
            if (n <= (long)avail) {
                this.pos = (int)((long)this.pos + n);
                return n;
            }
            this.pos = this.buf.length;
            n -= (long)avail;
        }
        return (long)avail + super.skip(n);
    }
}

