/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.internal.filewatcher;

import com.openexchange.config.internal.filewatcher.FileListener;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public final class FileWatcher {
    static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(FileWatcher.class));
    private static final ConcurrentMap<File, FileWatcher> fileWatchers = new ConcurrentHashMap<File, FileWatcher>();
    private static volatile Timer fileWatcherTimer;
    final File file;
    private final ConcurrentMap<Class<? extends FileListener>, FileListener> listeners;
    private final AtomicBoolean started = new AtomicBoolean();
    private TimerTask timerTask;
    volatile long timeStamp;

    public static FileWatcher getFileWatcher(File file) {
        FileWatcher newfw;
        FileWatcher fw = (FileWatcher)fileWatchers.get(file);
        if (null == fw && null == (fw = fileWatchers.putIfAbsent(file, newfw = new FileWatcher(file)))) {
            fw = newfw;
        }
        return fw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initTimer() {
        Timer timer = fileWatcherTimer;
        if (null != timer) return;
        Class<FileWatcher> clazz = FileWatcher.class;
        synchronized (FileWatcher.class) {
            timer = fileWatcherTimer;
            if (null != timer) return;
            fileWatcherTimer = timer = new Timer("FileWatcherTimer");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void dropTimer() {
        Timer timer = fileWatcherTimer;
        if (null == timer) return;
        Class<FileWatcher> clazz = FileWatcher.class;
        synchronized (FileWatcher.class) {
            timer = fileWatcherTimer;
            if (null == timer) return;
            timer.cancel();
            fileWatcherTimer = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private FileWatcher(File file) {
        this.listeners = new ConcurrentHashMap<Class<? extends FileListener>, FileListener>();
        this.file = file;
        this.timeStamp = file.lastModified();
    }

    public void addFileListener(FileListener listener) {
        this.listeners.putIfAbsent(listener.getClass(), listener);
    }

    void notifyListeners(boolean onDelete) {
        if (onDelete) {
            for (FileListener fileListener : this.listeners.values()) {
                fileListener.onDelete();
            }
        } else {
            for (FileListener fileListener : this.listeners.values()) {
                fileListener.onChange(this.file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFileWatcher(long period) {
        if (!this.started.get()) {
            FileWatcher fileWatcher = this;
            synchronized (fileWatcher) {
                if (!this.started.get()) {
                    this.timerTask = new FileWatcherTimerTask();
                    FileWatcher.initTimer();
                    fileWatcherTimer.schedule(this.timerTask, 1000L, period);
                    this.started.set(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFileWatcher() {
        if (this.started.get()) {
            FileWatcher fileWatcher = this;
            synchronized (fileWatcher) {
                if (this.started.get()) {
                    this.timerTask.cancel();
                    fileWatcherTimer.purge();
                    this.started.set(false);
                }
            }
        }
    }

    private final class FileWatcherTimerTask
    extends TimerTask {
        FileWatcherTimerTask() {
        }

        @Override
        public void run() {
            try {
                long newTimeStamp;
                if (!FileWatcher.this.file.exists()) {
                    FileWatcher.this.notifyListeners(true);
                }
                if (FileWatcher.this.timeStamp != (newTimeStamp = FileWatcher.this.file.lastModified())) {
                    FileWatcher.this.timeStamp = newTimeStamp;
                    FileWatcher.this.notifyListeners(false);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

