/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.test.fixtures.DayOnlyDateComparator;
import com.openexchange.test.fixtures.DefaultFixtures;
import com.openexchange.test.fixtures.Fixture;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.FixtureFactory;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.Fixtures;
import com.openexchange.test.fixtures.transformators.BooleanTransformator;
import com.openexchange.test.fixtures.transformators.DistributionListTransformator;
import com.openexchange.test.fixtures.transformators.FileToByteArrayTransformator;
import com.openexchange.test.fixtures.transformators.Transformator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ContactFixtureFactory
implements FixtureFactory<Contact> {
    private final FixtureLoader fixtureLoader;

    public ContactFixtureFactory(FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Fixtures<Contact> createFixture(String fixtureName, Map<String, Map<String, String>> entries) {
        return new ContactFixtures(fixtureName, entries, this.fixtureLoader);
    }

    private class ContactFixtures
    extends DefaultFixtures<Contact>
    implements Fixtures<Contact> {
        private final Map<String, Map<String, String>> entries;
        private final Map<String, Fixture<Contact>> contacts;

        public ContactFixtures(String fixtureName, Map<String, Map<String, String>> entries, FixtureLoader fixtureLoader) {
            super(Contact.class, entries, fixtureLoader);
            this.contacts = new HashMap<String, Fixture<Contact>>();
            this.entries = entries;
            this.addTransformator((Transformator)new DistributionListTransformator(fixtureLoader), "distribution_list");
            this.addTransformator((Transformator)new BooleanTransformator(), "private_flag");
            this.addTransformator((Transformator)new FileToByteArrayTransformator(fixtureLoader), "image1");
        }

        @Override
        public Fixture<Contact> getEntry(String entryName) throws OXException {
            if (this.contacts.containsKey(entryName)) {
                return this.contacts.get(entryName);
            }
            Map<String, String> values = this.entries.get(entryName);
            if (null == values) {
                throw new FixtureException("Entry with name " + entryName + " not found");
            }
            this.defaults(values);
            Contact contact = new Contact();
            this.apply(contact, values);
            Fixture<Contact> fixture = new Fixture<Contact>(contact, values.keySet().toArray(new String[values.size()]), values){

                @Override
                public Comparator getComparator(String field) {
                    if ("birthday".equals(field) || "anniversary".equals(field)) {
                        return new DayOnlyDateComparator();
                    }
                    return super.getComparator(field);
                }
            };
            this.contacts.put(entryName, fixture);
            return fixture;
        }

        private void defaults(Map values) {
            if (!values.containsKey("display_name")) {
                String givenName;
                String surName = values.containsKey("sur_name") ? values.get("sur_name").toString() : null;
                String string = givenName = values.containsKey("given_name") ? values.get("given_name").toString() : null;
                if (null != surName) {
                    values.put("display_name", null == givenName ? surName : String.format("%s, %s", surName, givenName));
                } else if (null != givenName) {
                    values.put("display_name", givenName);
                }
            }
        }
    }
}

