/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.setuptools;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupStorage;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.resource.storage.ResourceStorage;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import java.util.ArrayList;
import java.util.List;

public class TestContextToolkit {
    public int resolveUser(String username) {
        return this.resolveUser(username, this.getDefaultContext());
    }

    public int resolveUser(String username, Context ctx) {
        UserStorage uStorage = null;
        try {
            uStorage = UserStorage.getInstance();
            int pos = username.indexOf(64);
            return uStorage.getUserId(pos == -1 ? username : username.substring(0, pos), ctx);
        }
        catch (OXException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int resolveResource(String resource) {
        return this.resolveResource(resource, this.getDefaultContext());
    }

    public int resolveResource(String resource, Context ctx) {
        ResourceStorage rStorage = null;
        try {
            rStorage = ResourceStorage.getInstance();
            return rStorage.searchResources(resource, ctx)[0].getIdentifier();
        }
        catch (OXException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int resolveGroup(String group) {
        return this.resolveGroup(group, this.getDefaultContext());
    }

    public int resolveGroup(String group, Context ctx) {
        GroupStorage gStorage = null;
        try {
            gStorage = GroupStorage.getInstance();
            return gStorage.searchGroups(group, true, ctx)[0].getIdentifier();
        }
        catch (OXException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public Context getDefaultContext() {
        return this.getContextByName("defaultcontext");
    }

    public Context getContextByName(String name) {
        try {
            ContextStorage storage = ContextStorage.getInstance();
            return storage.getContext(storage.getContextId(name));
        }
        catch (OXException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int[] getGroups(int user, Context ctx) {
        try {
            return UserConfigurationStorage.getInstance().getUserConfiguration(user, ctx).getGroups();
        }
        catch (OXException e) {
            e.printStackTrace();
            return new int[0];
        }
    }

    public Session getSessionForUser(String user, Context ctx) {
        int userId = this.resolveUser(user, ctx);
        return SessionObjectWrapper.createSessionObject((int)userId, (Context)ctx, (String)("session for " + user));
    }

    public Group loadGroup(int id, Context ctx) {
        GroupStorage gStorage = null;
        try {
            gStorage = GroupStorage.getInstance();
            return gStorage.getGroup(id, ctx);
        }
        catch (OXException e) {
            e.printStackTrace();
            return null;
        }
    }

    public User loadUser(int userId, Context ctx) {
        UserStorage uStorage = null;
        try {
            uStorage = UserStorage.getInstance();
            return uStorage.getUser(userId, ctx);
        }
        catch (OXException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<UserParticipant> users(Context ctx, String ... users) {
        ArrayList<UserParticipant> participants = new ArrayList<UserParticipant>(users.length);
        TestContextToolkit tools = new TestContextToolkit();
        for (String user : users) {
            int id = tools.resolveUser(user, ctx);
            UserParticipant participant = new UserParticipant(id);
            participants.add(participant);
        }
        return participants;
    }

    public List<ResourceParticipant> resources(Context ctx, String ... resources) {
        ArrayList<ResourceParticipant> participants = new ArrayList<ResourceParticipant>(resources.length);
        TestContextToolkit tools = new TestContextToolkit();
        for (String resource : resources) {
            int id = tools.resolveResource(resource, ctx);
            ResourceParticipant participant = new ResourceParticipant(id);
            participants.add(participant);
        }
        return participants;
    }

    public List<GroupParticipant> groups(Context ctx, String ... groups) {
        ArrayList<GroupParticipant> participants = new ArrayList<GroupParticipant>(groups.length);
        TestContextToolkit tools = new TestContextToolkit();
        for (String group : groups) {
            int id = tools.resolveGroup(group, ctx);
            GroupParticipant participant = new GroupParticipant(id);
            participants.add(participant);
        }
        return participants;
    }
}

